/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.fife.rsta.ac.xml.ValidationConfig;
import org.fife.rsta.ac.xml.XmlParser;
import org.xml.sax.SAXException;

public class SchemaValidationConfig
implements ValidationConfig {
    private Schema schema;

    public SchemaValidationConfig(String string, InputStream inputStream) throws IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            try {
                this.schema = schemaFactory.newSchema(new StreamSource(bufferedInputStream));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                throw new IOException(sAXException.toString());
            }
        }
        finally {
            bufferedInputStream.close();
        }
    }

    @Override
    public void configureParser(XmlParser xmlParser) {
        SAXParserFactory sAXParserFactory = xmlParser.getSaxParserFactory();
        sAXParserFactory.setValidating(false);
        if (this.schema != null) {
            sAXParserFactory.setSchema(this.schema);
        }
    }

    @Override
    public void configureHandler(XmlParser.Handler handler) {
        handler.setEntityResolver(null);
    }
}

