/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.tree;

import javax.swing.Icon;
import org.fife.rsta.ac.java.DecoratableIcon;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.rjc.ast.AbstractTypeDeclarationNode;
import org.fife.rsta.ac.java.rjc.ast.EnumDeclaration;
import org.fife.rsta.ac.java.rjc.ast.NormalClassDeclaration;
import org.fife.rsta.ac.java.rjc.ast.NormalInterfaceDeclaration;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.tree.JavaTreeNode;

class TypeDeclarationTreeNode
extends JavaTreeNode {
    public TypeDeclarationTreeNode(TypeDeclaration typeDeclaration) {
        super(typeDeclaration);
        Object object;
        String string = null;
        int n = 0;
        if (typeDeclaration instanceof NormalClassDeclaration) {
            object = (NormalClassDeclaration)typeDeclaration;
            string = ((AbstractTypeDeclarationNode)object).getModifiers() != null ? (((AbstractTypeDeclarationNode)object).getModifiers().isPublic() ? "classIcon" : (((AbstractTypeDeclarationNode)object).getModifiers().isProtected() ? "innerClassProtectedIcon" : (((AbstractTypeDeclarationNode)object).getModifiers().isPrivate() ? "innerClassPrivateIcon" : "innerClassDefaultIcon"))) : "defaultClassIcon";
        } else if (typeDeclaration instanceof NormalInterfaceDeclaration) {
            object = (NormalInterfaceDeclaration)typeDeclaration;
            string = ((AbstractTypeDeclarationNode)object).getModifiers() != null && ((AbstractTypeDeclarationNode)object).getModifiers().isPublic() ? "interfaceIcon" : "defaultInterfaceIcon";
        } else if (typeDeclaration instanceof EnumDeclaration) {
            object = (EnumDeclaration)typeDeclaration;
            string = ((AbstractTypeDeclarationNode)object).getModifiers() != null ? (((AbstractTypeDeclarationNode)object).getModifiers().isPublic() ? "enumIcon" : (((AbstractTypeDeclarationNode)object).getModifiers().isProtected() ? "enumProtectedIcon" : (((AbstractTypeDeclarationNode)object).getModifiers().isPrivate() ? "enumPrivateIcon" : "enumDefaultIcon"))) : "enumDefaultIcon";
        }
        object = IconFactory.get();
        Icon icon = ((IconFactory)object).getIcon(string);
        if (icon == null) {
            System.out.println("*** " + typeDeclaration);
        } else {
            DecoratableIcon decoratableIcon = new DecoratableIcon(icon);
            decoratableIcon.setDeprecated(typeDeclaration.isDeprecated());
            Modifiers modifiers = typeDeclaration.getModifiers();
            if (modifiers != null) {
                if (modifiers.isAbstract()) {
                    decoratableIcon.addDecorationIcon(((IconFactory)object).getIcon("abstractIcon"));
                } else if (modifiers.isFinal()) {
                    decoratableIcon.addDecorationIcon(((IconFactory)object).getIcon("finalIcon"));
                }
                if (modifiers.isStatic()) {
                    decoratableIcon.addDecorationIcon(((IconFactory)object).getIcon("staticIcon"));
                    n = -16;
                }
            }
            this.setIcon(decoratableIcon);
        }
        this.setSortPriority(n);
    }

    @Override
    public String getText(boolean bl) {
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.getUserObject();
        return typeDeclaration != null ? typeDeclaration.getName() : null;
    }
}

