/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.tree;

import javax.swing.Icon;
import org.fife.rsta.ac.java.DecoratableIcon;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.rsta.ac.java.tree.JavaTreeNode;
import org.fife.ui.autocomplete.Util;

class MemberTreeNode
extends JavaTreeNode {
    private String text;

    public MemberTreeNode(CodeBlock codeBlock) {
        super(codeBlock);
        this.text = "<html>" + codeBlock.getName();
        IconFactory iconFactory = IconFactory.get();
        Icon icon = iconFactory.getIcon("methodPrivateIcon");
        DecoratableIcon decoratableIcon = new DecoratableIcon(icon);
        int n = 3;
        if (codeBlock.isStatic()) {
            decoratableIcon.addDecorationIcon(iconFactory.getIcon("staticIcon"));
            n -= 16;
        }
        this.setIcon(decoratableIcon);
        this.setSortPriority(n);
    }

    public MemberTreeNode(Field field) {
        super(field);
        Modifiers modifiers = field.getModifiers();
        String string = null;
        string = modifiers == null ? "fieldDefaultIcon" : (modifiers.isPrivate() ? "fieldPrivateIcon" : (modifiers.isProtected() ? "fieldProtectedIcon" : (modifiers.isPublic() ? "fieldPublicIcon" : "fieldDefaultIcon")));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(field.getName());
        stringBuilder.append(" : ");
        stringBuilder.append("<font color='#888888'>");
        MemberTreeNode.appendType(field.getType(), stringBuilder);
        this.text = stringBuilder.toString();
        int n = 1;
        IconFactory iconFactory = IconFactory.get();
        Icon icon = iconFactory.getIcon(string);
        DecoratableIcon decoratableIcon = new DecoratableIcon(icon);
        decoratableIcon.setDeprecated(field.isDeprecated());
        if (modifiers != null) {
            if (modifiers.isStatic()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("staticIcon"));
                n -= 16;
            }
            if (modifiers.isFinal()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("finalIcon"));
            }
        }
        this.setIcon(decoratableIcon);
        this.setSortPriority(n);
    }

    public MemberTreeNode(Method method) {
        super(method);
        Object object;
        String string = null;
        int n = 3;
        Modifiers modifiers = method.getModifiers();
        string = modifiers == null ? "methodDefaultIcon" : (modifiers.isPrivate() ? "methodPrivateIcon" : (modifiers.isProtected() ? "methodProtectedIcon" : (modifiers.isPublic() ? "methodPublicIcon" : "methodDefaultIcon")));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(method.getName());
        stringBuilder.append('(');
        int n2 = method.getParameterCount();
        int n3 = 0;
        while (n3 < n2) {
            object = method.getParameter(n3);
            MemberTreeNode.appendType(((LocalVariable)object).getType(), stringBuilder);
            if (n3 < n2 - 1) {
                stringBuilder.append(", ");
            }
            ++n3;
        }
        stringBuilder.append(')');
        if (method.getType() != null) {
            stringBuilder.append(" : ");
            stringBuilder.append("<font color='#888888'>");
            MemberTreeNode.appendType(method.getType(), stringBuilder);
        }
        this.text = stringBuilder.toString();
        IconFactory iconFactory = IconFactory.get();
        object = iconFactory.getIcon(string);
        DecoratableIcon decoratableIcon = new DecoratableIcon((Icon)object);
        decoratableIcon.setDeprecated(method.isDeprecated());
        if (modifiers != null) {
            if (modifiers.isAbstract()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("abstractIcon"));
            }
            if (method.isConstructor()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("constructorIcon"));
                n = 2;
            }
            if (modifiers.isStatic()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("staticIcon"));
                n -= 16;
            }
            if (modifiers.isFinal()) {
                decoratableIcon.addDecorationIcon(iconFactory.getIcon("finalIcon"));
            }
        }
        this.setIcon(decoratableIcon);
        this.setSortPriority(n);
    }

    static void appendType(Type type, StringBuilder stringBuilder) {
        if (type != null) {
            String string = type.toString();
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            stringBuilder.append(string);
        }
    }

    @Override
    public String getText(boolean bl) {
        return bl ? Util.stripHtml(this.text).replaceAll("&lt;", "<").replaceAll("&gt;", ">") : this.text;
    }
}

