/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.tree;

import javax.swing.Icon;
import org.fife.rsta.ac.SourceTreeNode;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.rjc.ast.ASTNode;

class JavaTreeNode
extends SourceTreeNode {
    private ASTNode astNode;
    private Icon icon;
    protected static final int PRIORITY_TYPE = 0;
    protected static final int PRIORITY_FIELD = 1;
    protected static final int PRIORITY_CONSTRUCTOR = 2;
    protected static final int PRIORITY_METHOD = 3;
    protected static final int PRIORITY_LOCAL_VAR = 4;
    protected static final int PRIORITY_BOOST_STATIC = -16;

    protected JavaTreeNode(ASTNode aSTNode) {
        this(aSTNode, null);
    }

    protected JavaTreeNode(ASTNode aSTNode, String string) {
        this(aSTNode, string, false);
    }

    protected JavaTreeNode(ASTNode aSTNode, String string, boolean bl) {
        super(aSTNode, bl);
        this.astNode = aSTNode;
        if (string != null) {
            this.setIcon(IconFactory.get().getIcon(string));
        }
    }

    public JavaTreeNode(String string, String string2) {
        this(string, string2, false);
    }

    public JavaTreeNode(String string, String string2, boolean bl) {
        super(string, bl);
        if (string2 != null) {
            this.icon = IconFactory.get().getIcon(string2);
        }
    }

    @Override
    public int compareTo(SourceTreeNode sourceTreeNode) {
        int n = -1;
        if (sourceTreeNode instanceof JavaTreeNode) {
            JavaTreeNode javaTreeNode = (JavaTreeNode)sourceTreeNode;
            n = this.getSortPriority() - javaTreeNode.getSortPriority();
            if (n == 0 && ((SourceTreeNode)this.getParent()).isSorted()) {
                n = this.getText(false).compareToIgnoreCase(javaTreeNode.getText(false));
            }
        }
        return n;
    }

    public ASTNode getASTNode() {
        return this.astNode;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean bl) {
        Object object = this.getUserObject();
        return object != null ? object.toString() : null;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String toString() {
        return this.getText(false);
    }
}

