/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.SourceTreeNode;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.rjc.ast.ASTNode;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.NormalClassDeclaration;
import org.fife.rsta.ac.java.rjc.ast.NormalInterfaceDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.tree.AstTreeCellRenderer;
import org.fife.rsta.ac.java.tree.JavaTreeNode;
import org.fife.rsta.ac.java.tree.LocalVarTreeNode;
import org.fife.rsta.ac.java.tree.MemberTreeNode;
import org.fife.rsta.ac.java.tree.TypeDeclarationTreeNode;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class JavaOutlineTree
extends AbstractSourceTree {
    private DefaultTreeModel model;
    private RSyntaxTextArea textArea;
    private JavaParser parser;
    private Listener listener;

    public JavaOutlineTree() {
        this(false);
    }

    public JavaOutlineTree(boolean bl) {
        this.setSorted(bl);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.setRootVisible(false);
        this.setCellRenderer(new AstTreeCellRenderer());
        this.model = new DefaultTreeModel(new DefaultMutableTreeNode("Nothing"));
        this.setModel(this.model);
        this.listener = new Listener();
        this.addTreeSelectionListener(this.listener);
    }

    private void update(CompilationUnit compilationUnit) {
        Object object;
        Object object2;
        Object object3;
        JavaTreeNode javaTreeNode = new JavaTreeNode("Remove me!", "sourceFileIcon");
        javaTreeNode.setSortable(false);
        if (compilationUnit == null) {
            this.model.setRoot(javaTreeNode);
            return;
        }
        Package package_ = compilationUnit.getPackage();
        if (package_ != null) {
            object3 = "packageIcon";
            javaTreeNode.add(new JavaTreeNode(package_, (String)object3, false));
        }
        if (!this.getShowMajorElementsOnly()) {
            object3 = new JavaTreeNode("Imports", "importRootIcon");
            object2 = compilationUnit.getImportIterator();
            while (object2.hasNext()) {
                object = (ImportDeclaration)object2.next();
                JavaTreeNode javaTreeNode2 = new JavaTreeNode((ASTNode)object, "importIcon");
                ((SourceTreeNode)object3).add(javaTreeNode2);
            }
            javaTreeNode.add((MutableTreeNode)object3);
        }
        object3 = compilationUnit.getTypeDeclarationIterator();
        while (object3.hasNext()) {
            object2 = (TypeDeclaration)object3.next();
            object = this.createTypeDeclarationNode((TypeDeclaration)object2);
            javaTreeNode.add((MutableTreeNode)object);
        }
        this.model.setRoot(javaTreeNode);
        javaTreeNode.setSorted(this.isSorted());
        this.refresh();
    }

    private void checkForJavaParsing() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("CompilationUnit", this.listener);
            this.parser = null;
        }
        LanguageSupportFactory languageSupportFactory = LanguageSupportFactory.get();
        LanguageSupport languageSupport = languageSupportFactory.getSupportFor("text/java");
        JavaLanguageSupport javaLanguageSupport = (JavaLanguageSupport)languageSupport;
        this.parser = javaLanguageSupport.getParser(this.textArea);
        if (this.parser != null) {
            this.parser.addPropertyChangeListener("CompilationUnit", this.listener);
            CompilationUnit compilationUnit = this.parser.getCompilationUnit();
            this.update(compilationUnit);
        } else {
            this.update((CompilationUnit)null);
        }
    }

    private MemberTreeNode createMemberNode(Member member) {
        MemberTreeNode memberTreeNode = null;
        memberTreeNode = member instanceof CodeBlock ? new MemberTreeNode((CodeBlock)member) : (member instanceof Field ? new MemberTreeNode((Field)member) : new MemberTreeNode((Method)member));
        CodeBlock codeBlock = null;
        if (member instanceof CodeBlock) {
            codeBlock = (CodeBlock)member;
        } else if (member instanceof Method) {
            codeBlock = ((Method)member).getBody();
        }
        if (codeBlock != null && !this.getShowMajorElementsOnly()) {
            int n = 0;
            while (n < codeBlock.getLocalVarCount()) {
                LocalVariable localVariable = codeBlock.getLocalVar(n);
                LocalVarTreeNode localVarTreeNode = new LocalVarTreeNode(localVariable);
                memberTreeNode.add(localVarTreeNode);
                ++n;
            }
        }
        return memberTreeNode;
    }

    private TypeDeclarationTreeNode createTypeDeclarationNode(TypeDeclaration typeDeclaration) {
        TypeDeclarationTreeNode typeDeclarationTreeNode;
        block5: {
            block4: {
                typeDeclarationTreeNode = new TypeDeclarationTreeNode(typeDeclaration);
                if (!(typeDeclaration instanceof NormalClassDeclaration)) break block4;
                NormalClassDeclaration normalClassDeclaration = (NormalClassDeclaration)typeDeclaration;
                int n = 0;
                while (n < normalClassDeclaration.getChildTypeCount()) {
                    TypeDeclaration typeDeclaration2 = normalClassDeclaration.getChildType(n);
                    TypeDeclarationTreeNode typeDeclarationTreeNode2 = this.createTypeDeclarationNode(typeDeclaration2);
                    typeDeclarationTreeNode.add(typeDeclarationTreeNode2);
                    ++n;
                }
                Iterator<Member> iterator = normalClassDeclaration.getMemberIterator();
                while (iterator.hasNext()) {
                    typeDeclarationTreeNode.add(this.createMemberNode(iterator.next()));
                }
                break block5;
            }
            if (!(typeDeclaration instanceof NormalInterfaceDeclaration)) break block5;
            NormalInterfaceDeclaration normalInterfaceDeclaration = (NormalInterfaceDeclaration)typeDeclaration;
            int n = 0;
            while (n < normalInterfaceDeclaration.getChildTypeCount()) {
                TypeDeclaration typeDeclaration3 = normalInterfaceDeclaration.getChildType(n);
                TypeDeclarationTreeNode typeDeclarationTreeNode3 = this.createTypeDeclarationNode(typeDeclaration3);
                typeDeclarationTreeNode.add(typeDeclarationTreeNode3);
                ++n;
            }
            Iterator<Member> iterator = normalInterfaceDeclaration.getMemberIterator();
            while (iterator.hasNext()) {
                typeDeclarationTreeNode.add(this.createMemberNode(iterator.next()));
            }
        }
        return typeDeclarationTreeNode;
    }

    @Override
    public void expandInitialNodes() {
        int n = 0;
        while (n < this.getRowCount()) {
            this.collapseRow(n++);
        }
        this.expandRow(0);
        n = 1;
        while (n < this.getRowCount()) {
            TreePath treePath = this.getPathForRow(n);
            Object object = treePath.getLastPathComponent();
            if (object instanceof TypeDeclarationTreeNode) {
                this.expandPath(treePath);
            }
            ++n;
        }
    }

    private void gotoElementAtPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ASTNode) {
            ASTNode aSTNode = (ASTNode)object;
            int n = aSTNode.getNameStartOffset();
            int n2 = aSTNode.getNameEndOffset();
            DocumentRange documentRange = new DocumentRange(n, n2);
            RSyntaxUtilities.selectAndPossiblyCenter(this.textArea, documentRange, true);
        }
    }

    @Override
    public boolean gotoSelectedElement() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath != null) {
            this.gotoElementAtPath(treePath);
            return true;
        }
        return false;
    }

    @Override
    public void listenTo(RSyntaxTextArea rSyntaxTextArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        if (rSyntaxTextArea == null) {
            return;
        }
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.addPropertyChangeListener("RSTA.syntaxStyle", this.listener);
        this.checkForJavaParsing();
    }

    @Override
    public void uninstall() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("CompilationUnit", this.listener);
            this.parser = null;
        }
        if (this.textArea != null) {
            this.textArea.removePropertyChangeListener("RSTA.syntaxStyle", this.listener);
            this.textArea = null;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setCellRenderer(new AstTreeCellRenderer());
    }

    private class Listener
    implements PropertyChangeListener,
    TreeSelectionListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RSTA.syntaxStyle".equals(string)) {
                JavaOutlineTree.this.checkForJavaParsing();
            } else if ("CompilationUnit".equals(string)) {
                CompilationUnit compilationUnit = (CompilationUnit)propertyChangeEvent.getNewValue();
                JavaOutlineTree.this.update(compilationUnit);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath;
            if (JavaOutlineTree.this.getGotoSelectedElementOnClick() && (treePath = treeSelectionEvent.getNewLeadSelectionPath()) != null) {
                JavaOutlineTree.this.gotoElementAtPath(treePath);
            }
        }
    }
}

