/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.lexer;

import org.fife.rsta.ac.java.rjc.lexer.Token;

class TokenImpl
implements Token {
    private int type;
    private String lexeme;
    private int line;
    private int column;
    private int offset;
    private boolean invalid;

    public TokenImpl(int n, String string, int n2, int n3, int n4) {
        this(n, string, n2, n3, n4, false);
    }

    public TokenImpl(int n, String string, int n2, int n3, int n4, boolean bl) {
        this.type = n;
        this.lexeme = string;
        this.line = n2;
        this.column = n3;
        this.offset = n4;
        this.invalid = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Token) {
            Token token = (Token)object;
            return this.type == token.getType() && this.lexeme.equals(token.getLexeme()) && this.line == token.getLine() && this.column == token.getColumn() && this.invalid == token.isInvalid();
        }
        return false;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLength() {
        return this.lexeme.length();
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.lexeme.hashCode();
    }

    @Override
    public boolean isBasicType() {
        switch (this.getType()) {
            case 131075: 
            case 131077: 
            case 131080: 
            case 131086: 
            case 131092: 
            case 131099: 
            case 131101: 
            case 131109: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentifier() {
        return (this.getType() & 0x40000) > 0;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public boolean isOperator() {
        return (this.getType() & 0x1000000) > 0;
    }

    @Override
    public boolean isType(int n) {
        return this.type == n;
    }

    public String toString() {
        return "[TokenImpl: type=" + this.type + "; lexeme=\"" + this.lexeme + "\"" + "; line=" + this.getLine() + "; col=" + this.getColumn() + "; offs=" + this.getOffset() + "; invalid=" + this.isInvalid() + "]";
    }
}

