/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.lexer;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.fife.rsta.ac.java.rjc.lexer.Offset;
import org.fife.rsta.ac.java.rjc.lexer.SourceCodeScanner;
import org.fife.rsta.ac.java.rjc.lexer.Token;
import org.fife.rsta.ac.java.rjc.lexer.TokenImpl;

public class Scanner {
    private static final boolean DEBUG = false;
    private SourceCodeScanner s;
    private Stack<Token> stack;
    private int typeArgLevel;
    private Document doc;
    private Token mostRecentToken;
    private Stack<Stack<Token>> resetPositions;
    private Stack<Token> currentResetTokenStack;
    private int currentResetStartOffset;

    public Scanner() {
        this((Reader)null);
    }

    public Scanner(List<Token> list) {
        this.stack = new Stack();
        int n = list.size() - 1;
        while (n >= 0) {
            this.stack.push(list.get(n));
            --n;
        }
    }

    public Scanner(Reader reader) {
        this.s = reader != null ? new SourceCodeScanner(reader) : null;
        this.s.setKeepLastDocComment(true);
        this.stack = new Stack();
    }

    private void pushOntoStack(Token token) {
        if (token != null && !this.stack.isEmpty() && token.equals(this.stack.peek())) {
            System.err.println("ERROR: Token being duplicated: " + token);
            Thread.dumpStack();
            System.exit(5);
        } else if (token == null) {
            System.err.println("ERROR: null token pushed onto stack");
            Thread.dumpStack();
            System.exit(6);
        }
        this.stack.push(token);
    }

    public void decreaseTypeArgumentsLevel() {
        if (--this.typeArgLevel < 0) {
            throw new InternalError("typeArgLevel dipped below 0");
        }
    }

    public Offset createOffset(final int n) {
        if (this.doc != null) {
            try {
                return new DocumentOffset(this.doc.createPosition(n));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return new Offset(){

            @Override
            public int getOffset() {
                return n;
            }
        };
    }

    private void debugPrintToken(Token token) {
    }

    public int getColumn() {
        return this.s.getColumn();
    }

    public String getLastDocComment() {
        return this.s.getLastDocComment();
    }

    public int getLine() {
        return this.s.getLine();
    }

    public Token getMostRecentToken() {
        return this.mostRecentToken;
    }

    public int getOffset() {
        return this.s.getOffset();
    }

    public void eatParenPairs() throws IOException {
        Token token = this.yylex();
        if (token == null || token.getType() != 0x800001) {
            throw new InternalError("'(' expected, found: " + token);
        }
        int n = 0;
        int n2 = 1;
        block6: while ((token = this.yylex()) != null) {
            int n3 = token.getType();
            switch (n3) {
                case 0x800003: {
                    ++n;
                    break;
                }
                case 0x800004: {
                    n = Math.max(n - 1, 0);
                    break;
                }
                case 0x800001: {
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case 0x800002: {
                    if (n != 0 || --n2 != 0) continue block6;
                    return;
                }
            }
        }
    }

    public void eatThroughNext(int n) throws IOException {
        Token token = null;
        while ((token = this.yylex()) != null && token.getType() != n) {
        }
    }

    public void eatThroughNextSkippingBlocks(int n) throws IOException {
        Token token = null;
        int n2 = 0;
        while ((token = this.yylex()) != null) {
            int n3 = token.getType();
            if (n3 == 0x800003) {
                ++n2;
                continue;
            }
            if (n3 == 0x800004) {
                --n2;
                continue;
            }
            if (n3 != n || n2 > 0) continue;
            return;
        }
    }

    public Token eatThroughNextSkippingBlocks(int n, int n2) throws IOException {
        Token token = null;
        int n3 = 0;
        while ((token = this.yylex()) != null) {
            int n4 = token.getType();
            if (n4 == 0x800003) {
                ++n3;
                continue;
            }
            if (n4 == 0x800004) {
                --n3;
                continue;
            }
            if (n4 != n && n4 != n2 || n3 > 0) continue;
            return token;
        }
        return null;
    }

    public Token eatThroughNextSkippingBlocksAndStuffInParens(int n, int n2) throws IOException {
        Token token = null;
        int n3 = 0;
        int n4 = 0;
        block6: while ((token = this.yylex()) != null) {
            int n5 = token.getType();
            switch (n5) {
                case 0x800003: {
                    ++n3;
                    break;
                }
                case 0x800004: {
                    --n3;
                    break;
                }
                case 0x800001: {
                    ++n4;
                    break;
                }
                case 0x800002: {
                    --n4;
                    break;
                }
                default: {
                    if (n5 != n && n5 != n2 || n3 > 0 || n4 > 0) continue block6;
                    return token;
                }
            }
        }
        return null;
    }

    public void eatUntilNext(int n, int n2) throws IOException {
        Token token = null;
        while ((token = this.yylex()) != null) {
            int n3 = token.getType();
            if (n3 != n && n3 != n2) continue;
            this.yyPushback(token);
            break;
        }
    }

    public void eatUntilNext(int n, int n2, int n3) throws IOException {
        Token token = null;
        while ((token = this.yylex()) != null) {
            int n4 = token.getType();
            if (n4 != n && n4 != n2 && n4 != n3) continue;
            this.yyPushback(token);
            break;
        }
    }

    public int getTypeArgumentsLevel() {
        return this.typeArgLevel;
    }

    public void increaseTypeArgumentsLevel() {
        ++this.typeArgLevel;
    }

    public void markResetPosition() {
        if (this.s != null) {
            if (this.resetPositions == null) {
                this.resetPositions = new Stack();
            }
            this.currentResetTokenStack = new Stack();
            this.resetPositions.push(this.currentResetTokenStack);
            this.currentResetStartOffset = this.s.getOffset();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetToLastMarkedPosition() {
        block2: {
            if (this.s == null) break block2;
            if (this.currentResetTokenStack != null) ** GOTO lbl7
            throw new InternalError("No resetTokenStack!");
            while ((var1_1 = this.stack.peek()).getOffset() >= this.currentResetStartOffset) {
                this.stack.pop();
lbl7:
                // 2 sources

                if (!this.stack.isEmpty()) continue;
            }
            while (!this.currentResetTokenStack.isEmpty()) {
                var1_1 = this.currentResetTokenStack.pop();
                this.stack.push(var1_1);
            }
            this.resetPositions.pop();
            this.currentResetTokenStack = this.resetPositions.isEmpty() != false ? null : this.resetPositions.peek();
            this.currentResetStartOffset = -1;
        }
    }

    public void clearResetPosition() {
        if (this.s != null) {
            if (this.currentResetTokenStack == null) {
                throw new InternalError("No resetTokenStack!");
            }
            this.resetPositions.pop();
            this.currentResetTokenStack = this.resetPositions.isEmpty() ? null : this.resetPositions.peek();
            this.currentResetStartOffset = -1;
        }
    }

    public void setDocument(Document document) {
        this.doc = document;
    }

    public int skipBracketPairs() throws IOException {
        int n = 0;
        while (this.yyPeekCheckType() == 0x800005 && this.yyPeekCheckType(2) == 0x800006) {
            this.yylex();
            this.yylex();
            ++n;
        }
        return n;
    }

    public Token yylex() throws IOException {
        String string;
        Token token = null;
        token = this.stack.isEmpty() ? (this.s != null ? this.s.yylex() : null) : this.stack.pop();
        if (this.typeArgLevel > 0 && token != null && token.isOperator() && (string = token.getLexeme()).length() > 1) {
            char c = string.charAt(0);
            if (c == '<') {
                TokenImpl tokenImpl = null;
                switch (token.getType()) {
                    case 0x1000009: {
                        tokenImpl = new TokenImpl(0x2000001, "=", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x1000018: {
                        tokenImpl = new TokenImpl(0x1000003, "<", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x2000023: {
                        tokenImpl = new TokenImpl(0x1000009, "<=", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                    }
                }
                this.stack.push(tokenImpl);
                token = new TokenImpl(0x1000003, "<", token.getLine(), token.getColumn(), token.getOffset());
            } else if (c == '>') {
                TokenImpl tokenImpl = null;
                switch (token.getType()) {
                    case 0x100000A: {
                        tokenImpl = new TokenImpl(0x2000001, "=", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x1000019: {
                        tokenImpl = new TokenImpl(0x1000002, ">", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x100001A: {
                        tokenImpl = new TokenImpl(0x1000019, ">>", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x2000024: {
                        tokenImpl = new TokenImpl(0x100000A, ">=", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                        break;
                    }
                    case 0x2000025: {
                        tokenImpl = new TokenImpl(0x2000024, ">>=", token.getLine(), token.getColumn() + 1, token.getOffset() + 1);
                    }
                }
                this.stack.push(tokenImpl);
                token = new TokenImpl(0x1000002, ">", token.getLine(), token.getColumn(), token.getOffset());
            }
        }
        this.debugPrintToken(token);
        if (this.currentResetTokenStack != null) {
            this.currentResetTokenStack.push(token);
        }
        if (token != null) {
            this.mostRecentToken = token;
        }
        return token;
    }

    public Token yylexNonNull(String string) throws IOException {
        Token token = this.yylex();
        if (token == null) {
            throw new EOFException(string);
        }
        return token;
    }

    public Token yylexNonNull(int n, String string) throws IOException {
        return this.yylexNonNull(n, -1, string);
    }

    public Token yylexNonNull(int n, int n2, String string) throws IOException {
        return this.yylexNonNull(n, n2, -1, string);
    }

    public Token yylexNonNull(int n, int n2, int n3, String string) throws IOException {
        Token token = this.yylex();
        if (token == null) {
            throw new IOException(string);
        }
        if (!(token.getType() == n || n2 != -1 && token.getType() == n2 || n3 != -1 && token.getType() == n3)) {
            throw new IOException(String.valueOf(string) + ", found '" + token.getLexeme() + "'");
        }
        return token;
    }

    public Token yyPeek() throws IOException {
        Token token = this.yylex();
        if (token != null) {
            this.pushOntoStack(token);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    public Token yyPeek(int var1_1) throws IOException {
        if (var1_1 < 1) {
            throw new IllegalArgumentException("depth must be >= 1");
        }
        var2_2 = new Stack<Token>();
        var3_3 = 0;
        while (var3_3 < var1_1) {
            block4: {
                var4_5 = this.yylex();
                if (var4_5 == null) ** GOTO lbl10
                break block4;
lbl-1000:
                // 1 sources

                {
                    this.yyPushback((Token)var2_2.pop());
lbl10:
                    // 2 sources

                    ** while (!var2_2.isEmpty())
                }
lbl11:
                // 1 sources

                return null;
            }
            var2_2.push(var4_5);
            ++var3_3;
        }
        var3_4 = (Token)var2_2.peek();
        while (!var2_2.isEmpty()) {
            this.yyPushback((Token)var2_2.pop());
        }
        return var3_4;
    }

    public int yyPeekCheckType() throws IOException {
        Token token = this.yyPeek();
        return token != null ? token.getType() : -1;
    }

    public int yyPeekCheckType(int n) throws IOException {
        Token token = this.yyPeek(n);
        return token != null ? token.getType() : -1;
    }

    public Token yyPeekNonNull(String string) throws IOException {
        Token token = this.yyPeek();
        if (token == null) {
            throw new IOException(string);
        }
        return token;
    }

    public Token yyPeekNonNull(int n, String string) throws IOException {
        return this.yyPeekNonNull(n, -1, string);
    }

    public Token yyPeekNonNull(int n, int n2, String string) throws IOException {
        return this.yyPeekNonNull(n, n2, -1, string);
    }

    public Token yyPeekNonNull(int n, int n2, int n3, String string) throws IOException {
        Token token = this.yyPeek();
        if (token == null) {
            throw new IOException(string);
        }
        if (!(token.getType() == n || n2 != -1 && token.getType() == n2 || n3 != -1 && token.getType() == n3)) {
            throw new IOException(String.valueOf(string) + ", found '" + token.getLexeme() + "'");
        }
        return token;
    }

    public void yyPushback(Token token) {
        if (token != null) {
            this.pushOntoStack(token);
        }
    }

    private class DocumentOffset
    implements Offset {
        public Position pos;

        public DocumentOffset(Position position) {
            this.pos = position;
        }

        @Override
        public int getOffset() {
            return this.pos.getOffset();
        }
    }
}

