/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.lang;

import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.java.rjc.lang.TypeArgument;

public class Type {
    private List<String> identifiers = new ArrayList<String>(1);
    private List<List<TypeArgument>> typeArguments = new ArrayList<List<TypeArgument>>(1);
    private int bracketPairCount;

    public Type() {
    }

    public Type(String string) {
        this();
        this.addIdentifier(string, null);
    }

    public Type(String string, int n) {
        this();
        this.addIdentifier(string, null);
        this.setBracketPairCount(n);
    }

    public void addIdentifier(String string, List<TypeArgument> list) {
        this.identifiers.add(string);
        this.typeArguments.add(list);
    }

    public int getIdentifierCount() {
        return this.identifiers.size();
    }

    public String getName(boolean bl) {
        return this.getName(bl, true);
    }

    public String getName(boolean bl, boolean bl2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.identifiers.size();
        int n3 = n = bl ? 0 : n2 - 1;
        while (n3 < n2) {
            List<TypeArgument> list;
            int n4;
            stringBuilder.append(this.identifiers.get(n3).toString());
            if (bl2 && this.typeArguments.get(n3) != null && (n4 = (list = this.typeArguments.get(n3)).size()) > 0) {
                stringBuilder.append('<');
                int n5 = 0;
                while (n5 < n4) {
                    TypeArgument typeArgument = list.get(n5);
                    stringBuilder.append(typeArgument.toString());
                    if (n5 < n4 - 1) {
                        stringBuilder.append(", ");
                    }
                    ++n5;
                }
                stringBuilder.append('>');
            }
            if (n3 < n2 - 1) {
                stringBuilder.append('.');
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.bracketPairCount) {
            stringBuilder.append("[]");
            ++n3;
        }
        return stringBuilder.toString();
    }

    public List<TypeArgument> getTypeArguments(int n) {
        return this.typeArguments.get(n);
    }

    public void incrementBracketPairCount(int n) {
        this.bracketPairCount += n;
    }

    public boolean isArray() {
        return this.bracketPairCount > 0;
    }

    public boolean isBasicType() {
        boolean bl = false;
        if (!this.isArray() && this.identifiers.size() == 1 && this.typeArguments.get(0) == null) {
            String string = this.identifiers.get(0);
            bl = "byte".equals(string) || "float".equals(string) || "double".equals(string) || "int".equals(string) || "short".equals(string) || "long".equals(string) || "boolean".equals(string);
        }
        return bl;
    }

    public void setBracketPairCount(int n) {
        this.bracketPairCount = n;
    }

    public String toString() {
        return this.getName(true);
    }
}

