/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fife.rsta.ac.java.rjc.lang.Annotation;

public class Modifiers {
    public static final Integer ABSTRACT = new Integer(1024);
    public static final Integer FINAL = new Integer(16);
    public static final Integer INTERFACE = new Integer(512);
    public static final Integer NATIVE = new Integer(256);
    public static final Integer PRIVATE = new Integer(2);
    public static final Integer PROTECTED = new Integer(4);
    public static final Integer PUBLIC = new Integer(1);
    public static final Integer STATIC = new Integer(8);
    public static final Integer STRICTFP = new Integer(2048);
    public static final Integer SYNCHRONIZED = new Integer(32);
    public static final Integer TRANSIENT = new Integer(128);
    public static final Integer VOLATILE = new Integer(64);
    private List<Integer> modifiers = new ArrayList<Integer>(1);
    private List<Annotation> annotations = new ArrayList<Annotation>(0);
    private static final Map<Integer, String> MODIFIER_TEXT = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ABSTRACT, "abstract");
            this.put(FINAL, "final");
            this.put(INTERFACE, "interface");
            this.put(NATIVE, "native");
            this.put(PRIVATE, "private");
            this.put(PROTECTED, "protected");
            this.put(PUBLIC, "public");
            this.put(STATIC, "static");
            this.put(STRICTFP, "strictfp");
            this.put(SYNCHRONIZED, "synchronized");
            this.put(TRANSIENT, "transient");
            this.put(VOLATILE, "volatile");
        }
    };

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public boolean addModifier(int n) {
        Integer n2 = null;
        switch (n) {
            case 65537: {
                n2 = ABSTRACT;
                break;
            }
            case 65554: {
                n2 = FINAL;
                break;
            }
            case 65564: {
                n2 = INTERFACE;
                break;
            }
            case 65566: {
                n2 = NATIVE;
                break;
            }
            case 65569: {
                n2 = PRIVATE;
                break;
            }
            case 65570: {
                n2 = PROTECTED;
                break;
            }
            case 65571: {
                n2 = PUBLIC;
                break;
            }
            case 65574: {
                n2 = STATIC;
                break;
            }
            case 65575: {
                n2 = STRICTFP;
                break;
            }
            case 65578: {
                n2 = SYNCHRONIZED;
                break;
            }
            case 65582: {
                n2 = TRANSIENT;
                break;
            }
            case 65585: {
                n2 = VOLATILE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tokenType: " + n);
            }
        }
        int n3 = Collections.binarySearch(this.modifiers, n2);
        if (n3 < 0) {
            int n4 = -(n3 + 1);
            this.modifiers.add(n4, n2);
        }
        return n3 < 0;
    }

    private boolean containsModifier(Integer n) {
        return Collections.binarySearch(this.modifiers, n) >= 0;
    }

    public boolean isAbstract() {
        return this.containsModifier(ABSTRACT);
    }

    public boolean isFinal() {
        return this.containsModifier(FINAL);
    }

    public boolean isPrivate() {
        return this.containsModifier(PRIVATE);
    }

    public boolean isProtected() {
        return this.containsModifier(PROTECTED);
    }

    public boolean isPublic() {
        return this.containsModifier(PUBLIC);
    }

    public boolean isStatic() {
        return this.containsModifier(STATIC);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.annotations.size()) {
            stringBuilder.append(this.annotations.get(n).toString());
            if (n < this.annotations.size() - 1 || this.modifiers.size() > 0) {
                stringBuilder.append(' ');
            }
            ++n;
        }
        n = 0;
        while (n < this.modifiers.size()) {
            Integer n2 = this.modifiers.get(n);
            stringBuilder.append(MODIFIER_TEXT.get(n2));
            if (n < this.modifiers.size() - 1) {
                stringBuilder.append(' ');
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

