/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractTypeDeclarationNode;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.rsta.ac.java.rjc.lang.TypeParameter;
import org.fife.rsta.ac.java.rjc.lexer.Scanner;

public class NormalClassDeclaration
extends AbstractTypeDeclarationNode {
    private List<TypeParameter> typeParams;
    private Type extendedType;
    private List<Type> implementedList = new ArrayList<Type>(0);

    public NormalClassDeclaration(Scanner scanner, int n, String string) {
        super(string, scanner.createOffset(n), scanner.createOffset(n + string.length()));
        this.extendedType = new Type("java.lang.Object");
    }

    public void addImplemented(Type type) {
        this.implementedList.add(type);
    }

    public Type getExtendedType() {
        return this.extendedType;
    }

    public int getImplementedCount() {
        return this.implementedList.size();
    }

    public Iterator<Type> getImplementedIterator() {
        return this.implementedList.iterator();
    }

    public Method getMethodContainingOffset(int n) {
        Iterator<Method> iterator = this.getMethodIterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (!method.getBodyContainsOffset(n)) continue;
            return method;
        }
        return null;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParams;
    }

    @Override
    public String getTypeString() {
        return "class";
    }

    private boolean isTypeCompatible(Type type, String string) {
        String string2 = type.getName(false);
        int n = string2.indexOf(60);
        if (n > -1) {
            String string3 = null;
            int n2 = string2.indexOf(91, n);
            if (n2 > -1) {
                string3 = string2.substring(n2);
            }
            string2 = string2.substring(n);
            if (string3 != null) {
                string2 = String.valueOf(string2) + string3;
            }
        }
        return string2.equalsIgnoreCase(string);
    }

    public void setExtendedType(Type type) {
        this.extendedType = type;
    }

    public void setTypeParameters(List<TypeParameter> list) {
        this.typeParams = list;
    }
}

