/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractMember;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.rsta.ac.java.rjc.lexer.Scanner;
import org.fife.rsta.ac.java.rjc.lexer.Token;

public class Method
extends AbstractMember {
    private Modifiers modifiers;
    private Type type;
    private List<FormalParameter> parameters;
    private List<String> thrownTypeNames;
    private CodeBlock body;
    private boolean deprecated;
    private String docComment;

    public Method(Scanner scanner, Modifiers modifiers, Type type, Token token, List<FormalParameter> list, List<String> list2) {
        super(token.getLexeme(), scanner.createOffset(token.getOffset()), scanner.createOffset(token.getOffset() + token.getLength()));
        if (modifiers == null) {
            modifiers = new Modifiers();
        }
        this.modifiers = modifiers;
        this.type = type;
        this.parameters = list;
        this.thrownTypeNames = list2;
    }

    public CodeBlock getBody() {
        return this.body;
    }

    public boolean getBodyContainsOffset(int n) {
        return n >= this.getBodyStartOffset() && n < this.getBodyEndOffset();
    }

    public int getBodyEndOffset() {
        return this.body == null ? Integer.MAX_VALUE : this.body.getNameEndOffset();
    }

    public int getBodyStartOffset() {
        return this.getNameStartOffset();
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public String getNameAndParameters() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append('(');
        int n = this.getParameterCount();
        int n2 = 0;
        while (n2 < n) {
            FormalParameter formalParameter = this.getParameter(n2);
            stringBuilder.append(formalParameter.getType().getName(false));
            stringBuilder.append(' ');
            stringBuilder.append(formalParameter.getName());
            if (n2 < n - 1) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public FormalParameter getParameter(int n) {
        return this.parameters.get(n);
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public Iterator<FormalParameter> getParameterIterator() {
        return this.parameters.iterator();
    }

    public int getThrownTypeNameCount() {
        return this.thrownTypeNames == null ? 0 : this.thrownTypeNames.size();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isConstructor() {
        return this.type == null;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setBody(CodeBlock codeBlock) {
        this.body = codeBlock;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    public void setDocComment(String string) {
        this.docComment = string;
    }
}

