/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractASTNode;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.NormalClassDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclarationContainer;
import org.fife.rsta.ac.java.rjc.lang.Annotation;
import org.fife.rsta.ac.java.rjc.lexer.Offset;
import org.fife.rsta.ac.java.rjc.lexer.Token;
import org.fife.rsta.ac.java.rjc.notices.ParserNotice;

public class CompilationUnit
extends AbstractASTNode
implements TypeDeclarationContainer {
    private List<Annotation> annotations;
    private Package pkg;
    private List<ImportDeclaration> imports = new ArrayList<ImportDeclaration>(3);
    private List<TypeDeclaration> typeDeclarations = new ArrayList<TypeDeclaration>(1);
    private List<ParserNotice> notices;
    private static final Offset ZERO_OFFSET = new ZeroOffset();

    public CompilationUnit(String string) {
        super(string, ZERO_OFFSET);
    }

    public void addImportDeclaration(ImportDeclaration importDeclaration) {
        this.imports.add(importDeclaration);
    }

    public void addParserNotice(Token token, String string) {
        this.addParserNotice(new ParserNotice(token, string));
    }

    public void addParserNotice(ParserNotice parserNotice) {
        if (this.notices == null) {
            this.notices = new ArrayList<ParserNotice>();
            this.notices.add(parserNotice);
        }
    }

    @Override
    public void addTypeDeclaration(TypeDeclaration typeDeclaration) {
        this.typeDeclarations.add(typeDeclaration);
    }

    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public Iterator<Annotation> getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public TypeDeclaration getDeepestTypeDeclarationAtOffset(int n) {
        TypeDeclaration typeDeclaration = this.getTypeDeclarationAtOffset(n);
        if (typeDeclaration != null) {
            TypeDeclaration typeDeclaration2 = typeDeclaration.getChildTypeAtOffset(n);
            while (typeDeclaration2 != null) {
                typeDeclaration = typeDeclaration2;
                typeDeclaration2 = typeDeclaration.getChildTypeAtOffset(n);
            }
        }
        return typeDeclaration;
    }

    public Point getEnclosingMethodRange(int n) {
        Point point = null;
        Iterator<TypeDeclaration> iterator = this.getTypeDeclarationIterator();
        while (iterator.hasNext()) {
            TypeDeclaration typeDeclaration = iterator.next();
            int n2 = typeDeclaration.getBodyStartOffset();
            int n3 = typeDeclaration.getBodyEndOffset();
            if (n < n2 || n > n3) continue;
            if (typeDeclaration instanceof NormalClassDeclaration) {
                NormalClassDeclaration normalClassDeclaration = (NormalClassDeclaration)typeDeclaration;
                Iterator<Member> iterator2 = normalClassDeclaration.getMemberIterator();
                while (iterator2.hasNext()) {
                    Method method;
                    CodeBlock codeBlock;
                    Member member = iterator2.next();
                    if (!(member instanceof Method) || (codeBlock = (method = (Method)member).getBody()) == null) continue;
                    int n4 = method.getNameStartOffset();
                    int n5 = codeBlock.getNameEndOffset();
                    if (n < n4 || n > n5) continue;
                    point = new Point(n4, n5);
                    break;
                }
            }
            if (point != null) continue;
            point = new Point(n2, n3);
        }
        return point;
    }

    public int getImportCount() {
        return this.imports.size();
    }

    public List<ImportDeclaration> getImports() {
        return new ArrayList<ImportDeclaration>(this.imports);
    }

    public Iterator<ImportDeclaration> getImportIterator() {
        return this.imports.iterator();
    }

    public Package getPackage() {
        return this.pkg;
    }

    public String getPackageName() {
        return this.pkg == null ? null : this.pkg.getName();
    }

    public ParserNotice getParserNotice(int n) {
        if (this.notices == null) {
            throw new IndexOutOfBoundsException("No parser notices available");
        }
        return this.notices.get(n);
    }

    public int getParserNoticeCount() {
        return this.notices == null ? 0 : this.notices.size();
    }

    public TypeDeclaration getTypeDeclaration(int n) {
        return this.typeDeclarations.get(n);
    }

    public TypeDeclaration getTypeDeclarationAtOffset(int n) {
        TypeDeclaration typeDeclaration = null;
        for (TypeDeclaration typeDeclaration2 : this.typeDeclarations) {
            if (!typeDeclaration2.getBodyContainsOffset(n)) continue;
            typeDeclaration = typeDeclaration2;
            break;
        }
        return typeDeclaration;
    }

    public int getTypeDeclarationCount() {
        return this.typeDeclarations.size();
    }

    public Iterator<TypeDeclaration> getTypeDeclarationIterator() {
        return this.typeDeclarations.iterator();
    }

    public void setPackage(Package package_) {
        this.pkg = package_;
    }

    private static class ZeroOffset
    implements Offset {
        private ZeroOffset() {
        }

        @Override
        public int getOffset() {
            return 0;
        }
    }
}

