/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractMember;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.rsta.ac.java.rjc.lexer.Offset;

public class CodeBlock
extends AbstractMember {
    public static final String NAME = "{...}";
    private CodeBlock parent;
    private List<CodeBlock> children;
    private List<LocalVariable> localVars;
    private boolean isStatic;

    public CodeBlock(boolean bl, Offset offset) {
        super(NAME, offset);
        this.isStatic = bl;
    }

    public void add(CodeBlock codeBlock) {
        if (this.children == null) {
            this.children = new ArrayList<CodeBlock>();
        }
        this.children.add(codeBlock);
        codeBlock.setParent(this);
    }

    public void addLocalVariable(LocalVariable localVariable) {
        if (this.localVars == null) {
            this.localVars = new ArrayList<LocalVariable>();
        }
        this.localVars.add(localVariable);
    }

    public boolean containsOffset(int n) {
        return this.getNameEndOffset() >= n && this.getNameStartOffset() <= n;
    }

    public CodeBlock getChildBlock(int n) {
        return this.children.get(n);
    }

    public int getChildBlockCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public CodeBlock getDeepestCodeBlockContaining(int n) {
        if (!this.containsOffset(n)) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.getChildBlockCount()) {
            CodeBlock codeBlock = this.getChildBlock(n2);
            if (codeBlock.containsOffset(n)) {
                return codeBlock.getDeepestCodeBlockContaining(n);
            }
            ++n2;
        }
        return this;
    }

    @Override
    public String getDocComment() {
        return null;
    }

    public LocalVariable getLocalVar(int n) {
        return this.localVars.get(n);
    }

    public int getLocalVarCount() {
        return this.localVars == null ? 0 : this.localVars.size();
    }

    public List<LocalVariable> getLocalVarsBefore(int n) {
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>();
        if (this.localVars != null) {
            int n2 = 0;
            while (n2 < this.getLocalVarCount()) {
                LocalVariable localVariable = this.getLocalVar(n2);
                if (localVariable.getNameStartOffset() >= n) break;
                arrayList.add(localVariable);
                ++n2;
            }
        }
        if (this.parent != null) {
            arrayList.addAll(this.parent.getLocalVarsBefore(n));
        }
        return arrayList;
    }

    @Override
    public Modifiers getModifiers() {
        Modifiers modifiers = new Modifiers();
        if (this.isStatic) {
            modifiers.addModifier(65574);
        }
        return modifiers;
    }

    public CodeBlock getParent() {
        return this.parent;
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setParent(CodeBlock codeBlock) {
        this.parent = codeBlock;
    }
}

