/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.rjc.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.rjc.ast.AbstractASTNode;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lexer.Offset;

public abstract class AbstractTypeDeclarationNode
extends AbstractASTNode
implements TypeDeclaration {
    private Package pkg;
    private Modifiers modifiers;
    private TypeDeclaration parentType;
    private List<TypeDeclaration> childTypes;
    private Offset bodyStartOffs;
    private Offset bodyEndOffs;
    private boolean deprecated;
    private String docComment;
    private List<Member> memberList;

    public AbstractTypeDeclarationNode(String string, Offset offset) {
        super(string, offset);
        this.init();
    }

    public AbstractTypeDeclarationNode(String string, Offset offset, Offset offset2) {
        super(string, offset, offset2);
        this.init();
    }

    public void addMember(Member member) {
        member.setParentTypeDeclaration(this);
        this.memberList.add(member);
    }

    @Override
    public void addTypeDeclaration(TypeDeclaration typeDeclaration) {
        if (this.childTypes == null) {
            this.childTypes = new ArrayList<TypeDeclaration>(1);
        }
        typeDeclaration.setParentType(this);
        this.childTypes.add(typeDeclaration);
    }

    @Override
    public boolean getBodyContainsOffset(int n) {
        return n >= this.getBodyStartOffset() && n < this.getBodyEndOffset();
    }

    @Override
    public int getBodyEndOffset() {
        return this.bodyEndOffs != null ? this.bodyEndOffs.getOffset() : Integer.MAX_VALUE;
    }

    @Override
    public int getBodyStartOffset() {
        return this.bodyStartOffs == null ? 0 : this.bodyStartOffs.getOffset();
    }

    @Override
    public TypeDeclaration getChildType(int n) {
        return this.childTypes.get(n);
    }

    @Override
    public TypeDeclaration getChildTypeAtOffset(int n) {
        TypeDeclaration typeDeclaration = null;
        int n2 = 0;
        while (n2 < this.getChildTypeCount()) {
            TypeDeclaration typeDeclaration2 = this.getChildType(n2);
            if (typeDeclaration2.getBodyContainsOffset(n)) {
                typeDeclaration = typeDeclaration2;
                break;
            }
            ++n2;
        }
        return typeDeclaration;
    }

    @Override
    public int getChildTypeCount() {
        return this.childTypes == null ? 0 : this.childTypes.size();
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    @Override
    public Iterator<Field> getFieldIterator() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Iterator<Member> iterator = this.getMemberIterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            if (!(member instanceof Field)) continue;
            arrayList.add((Field)member);
        }
        return arrayList.iterator();
    }

    @Override
    public Member getMember(int n) {
        return this.memberList.get(n);
    }

    @Override
    public int getMemberCount() {
        return this.memberList.size();
    }

    @Override
    public Iterator<Member> getMemberIterator() {
        return this.memberList.iterator();
    }

    @Override
    public Iterator<Method> getMethodIterator() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Iterator<Member> iterator = this.getMemberIterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            if (!(member instanceof Method)) continue;
            arrayList.add((Method)member);
        }
        return arrayList.iterator();
    }

    @Override
    public List<Method> getMethodsByName(String string) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Iterator<Member> iterator = this.getMemberIterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            if (!(member instanceof Method) || !string.equals(member.getName())) continue;
            arrayList.add((Method)member);
        }
        return arrayList;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName(boolean bl) {
        Package package_;
        String string = this.getName();
        if (bl && (package_ = this.getPackage()) != null) {
            string = String.valueOf(package_.getName()) + "." + string;
        }
        return string;
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public TypeDeclaration getParentType() {
        return this.parentType;
    }

    private void init() {
        this.memberList = new ArrayList<Member>();
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isStatic() {
        return this.modifiers == null ? false : this.modifiers.isStatic();
    }

    public void setBodyEndOffset(Offset offset) {
        this.bodyEndOffs = offset;
    }

    public void setBodyStartOffset(Offset offset) {
        this.bodyStartOffs = offset;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    @Override
    public void setDocComment(String string) {
        this.docComment = string;
    }

    public void setModifiers(Modifiers modifiers) {
        this.modifiers = modifiers;
    }

    public void setPackage(Package package_) {
        this.pkg = package_;
    }

    @Override
    public void setParentType(TypeDeclaration typeDeclaration) {
        this.parentType = typeDeclaration;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.modifiers != null) {
            stringBuilder.append(this.modifiers.toString()).append(' ');
        }
        stringBuilder.append(this.getTypeString()).append(' ');
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }
}

