/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader.constantpool;

import java.io.DataInputStream;
import java.io.IOException;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantClassInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantDoubleInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantFieldrefInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantFloatInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantIntegerInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantInterfaceMethodrefInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantLongInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantMethodrefInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantNameAndTypeInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantPoolInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantStringInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantTypes;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantUtf8Info;

public class ConstantPoolInfoFactory
implements ConstantTypes {
    private ConstantPoolInfoFactory() {
    }

    public static ConstantPoolInfo readConstantPoolInfo(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        ConstantPoolInfo constantPoolInfo = null;
        int n = dataInputStream.read();
        switch (n) {
            case 7: {
                int n2 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantClassInfo(n2);
                break;
            }
            case 6: {
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                constantPoolInfo = new ConstantDoubleInfo(n3, n4);
                break;
            }
            case 9: {
                int n5 = dataInputStream.readUnsignedShort();
                int n6 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantFieldrefInfo(n5, n6);
                break;
            }
            case 4: {
                int n7 = dataInputStream.readInt();
                constantPoolInfo = new ConstantFloatInfo(n7);
                break;
            }
            case 3: {
                int n8 = dataInputStream.readInt();
                constantPoolInfo = new ConstantIntegerInfo((long)n8);
                break;
            }
            case 11: {
                int n9 = dataInputStream.readUnsignedShort();
                int n10 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantInterfaceMethodrefInfo(n9, n10);
                break;
            }
            case 5: {
                int n11 = dataInputStream.readInt();
                int n12 = dataInputStream.readInt();
                constantPoolInfo = new ConstantLongInfo(n11, n12);
                break;
            }
            case 10: {
                int n13 = dataInputStream.readUnsignedShort();
                int n14 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantMethodrefInfo(n13, n14);
                break;
            }
            case 12: {
                int n15 = dataInputStream.readUnsignedShort();
                int n16 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantNameAndTypeInfo(n15, n16);
                break;
            }
            case 8: {
                int n17 = dataInputStream.readUnsignedShort();
                constantPoolInfo = new ConstantStringInfo(classFile, n17);
                break;
            }
            case 1: {
                int n18 = dataInputStream.readUnsignedShort();
                byte[] byArray = new byte[n18];
                dataInputStream.readFully(byArray);
                constantPoolInfo = new ConstantUtf8Info(byArray);
                break;
            }
            default: {
                throw new IOException("Unknown tag for constant pool info: " + n);
            }
        }
        return constantPoolInfo;
    }
}

