/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;

public class Signature
extends AttributeInfo {
    private String signature;

    public Signature(ClassFile classFile, String string) {
        super(classFile);
        this.signature = string;
    }

    public List<String> getClassParamTypes() {
        ArrayList<String> arrayList = null;
        if (this.signature != null && this.signature.startsWith("<")) {
            arrayList = new ArrayList<String>(1);
            int n = this.skipLtGt(this.signature, 1);
            String string = this.signature.substring(1, n - 1);
            int n2 = 0;
            int n3 = string.indexOf(58, n2);
            while (n2 < string.length() && n3 > -1) {
                String string2 = string.substring(n2, n3);
                char c = string.charAt(n3 + 1);
                if (c == 'L') {
                    int n4 = string.indexOf(59, n3 + 2);
                    if (n4 > -1) {
                        arrayList.add(string2);
                        n2 = n4 + 1;
                        n3 = string.indexOf(58, n2);
                        continue;
                    }
                    System.err.println("WARN: Can't parse signature (1): " + this.signature);
                    break;
                }
                System.err.println("WARN: Can't parse signature (2): " + this.signature);
                break;
            }
        }
        return arrayList;
    }

    private int skipLtGt(String string, int n) {
        int n2 = 1;
        int n3 = n;
        while (n3 < string.length() && n2 > 0) {
            char c = string.charAt(n3++);
            switch (c) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    --n2;
                }
            }
        }
        return n3;
    }

    public List<String> getMethodParamTypes(MethodInfo methodInfo, ClassFile classFile, boolean bl) {
        ArrayList<String> arrayList = null;
        String string = this.signature;
        if (string != null) {
            String string2;
            int n;
            arrayList = new ArrayList<String>();
            Map<String, String> map = null;
            if (string.charAt(0) == '<') {
                n = this.skipLtGt(string, 1);
                string2 = string.substring(1, n - 1);
                map = this.parseAdditionalTypeArgs(string2);
                string = string.substring(n);
            }
            if (string.charAt(0) == '(') {
                n = string.indexOf(41, 1);
                string2 = string.substring(1, n);
                ParamDescriptorResult paramDescriptorResult = new ParamDescriptorResult();
                while (string2.length() > 0) {
                    this.parseParamDescriptor(string2, classFile, map, methodInfo, "Error parsing method signature for ", paramDescriptorResult, bl);
                    arrayList.add(paramDescriptorResult.type);
                    if (string2.length() > paramDescriptorResult.pos) {
                        string2 = string2.substring(paramDescriptorResult.pos);
                        continue;
                    }
                    break;
                }
            } else {
                System.out.println("TODO: Unhandled method signature for " + methodInfo.getName() + ": " + string);
            }
        }
        return arrayList;
    }

    public String getMethodReturnType(MethodInfo methodInfo, ClassFile classFile, boolean bl) {
        String string = this.signature;
        String string2 = null;
        if (string != null) {
            String string3;
            int n;
            Map<String, String> map = null;
            if (string.charAt(0) == '<') {
                n = this.skipLtGt(string, 1);
                string3 = string.substring(1, n - 1);
                map = this.parseAdditionalTypeArgs(string3);
                string = string.substring(n);
            }
            if (string.charAt(0) == '(') {
                n = string.indexOf(41, 1);
                if (n > -1 && n < string.length() - 3) {
                    string3 = string.substring(n + 1);
                    ParamDescriptorResult paramDescriptorResult = new ParamDescriptorResult();
                    this.parseParamDescriptor(string3, classFile, map, methodInfo, "Can't parse return type from method sig for ", paramDescriptorResult, bl);
                    string2 = paramDescriptorResult.type;
                }
            } else {
                System.out.println("TODO: Unhandled method signature for " + methodInfo.getName() + ": " + string);
            }
        }
        return string2;
    }

    public String getSignature() {
        return this.signature;
    }

    private String getTypeArgument(String string, ClassFile classFile, Map<String, String> map) {
        String string2 = classFile.getTypeArgument(string);
        if (string2 == null && map != null) {
            string2 = string;
        }
        return string2;
    }

    private Map<String, String> parseAdditionalTypeArgs(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        int n2 = string.indexOf(58, n);
        while (n < string.length()) {
            String string2 = string.substring(n, n2);
            int n3 = string.indexOf(59, n + 1);
            int n4 = string.indexOf(60, n + 1);
            if (n4 > -1 && n4 < n3) {
                int n5 = this.skipLtGt(string, n4 + 1);
                String string3 = string.substring(n2 + 1, n5);
                hashMap.put(string2, string3);
                n = n5 + 1;
            } else {
                String string4 = string.substring(n2 + 1, n3);
                hashMap.put(string2, string4);
                n = n3 + 1;
            }
            n2 = string.indexOf(58, n);
        }
        return hashMap;
    }

    private ParamDescriptorResult parseParamDescriptor(String string, ClassFile classFile, Map<String, String> map, MethodInfo methodInfo, String string2, ParamDescriptorResult paramDescriptorResult, boolean bl) {
        int n;
        int n2 = -1;
        while (string.charAt(++n2) == '[') {
        }
        int n3 = n2;
        String string3 = null;
        boolean bl2 = false;
        switch (string.charAt(n3)) {
            case 'B': {
                string3 = "byte";
                ++n3;
                break;
            }
            case 'C': {
                string3 = "char";
                ++n3;
                break;
            }
            case 'D': {
                string3 = "double";
                ++n3;
                break;
            }
            case 'F': {
                string3 = "float";
                ++n3;
                break;
            }
            case 'I': {
                string3 = "int";
                ++n3;
                break;
            }
            case 'J': {
                string3 = "long";
                ++n3;
                break;
            }
            case 'S': {
                string3 = "short";
                ++n3;
                break;
            }
            case 'Z': {
                string3 = "boolean";
                ++n3;
                break;
            }
            case 'L': {
                String string4;
                n = string.indexOf(59, n3 + 1);
                int n4 = string.indexOf(60, n3 + 1);
                if (n4 > -1 && n4 < n) {
                    int n5 = this.skipLtGt(string, n4 + 1);
                    if (n5 == string.length() || string.charAt(n5) != ';') {
                        System.out.println("TODO: " + string2 + methodInfo.getName() + ": " + this.signature);
                        string3 = "ERROR_PARSING_METHOD_SIG";
                        break;
                    }
                    string3 = string.substring(n3 + 1, n4);
                    string3 = bl ? string3.replace('/', '.') : string3.substring(string3.lastIndexOf(47) + 1);
                    string4 = string.substring(n4 + 1, n5 - 1);
                    ParamDescriptorResult paramDescriptorResult2 = new ParamDescriptorResult();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (string4.length() > 0) {
                        this.parseParamDescriptor(string4, classFile, map, methodInfo, "Error parsing method signature for ", paramDescriptorResult2, bl);
                        arrayList.add(paramDescriptorResult2.type);
                        if (string4.length() <= paramDescriptorResult2.pos) break;
                        string4 = string4.substring(paramDescriptorResult2.pos);
                    }
                    StringBuilder stringBuilder = new StringBuilder(string3).append('<');
                    int n6 = 0;
                    while (n6 < arrayList.size()) {
                        stringBuilder.append((String)arrayList.get(n6));
                        if (n6 < arrayList.size() - 1) {
                            stringBuilder.append(", ");
                        }
                        ++n6;
                    }
                    string3 = stringBuilder.append('>').toString();
                    n3 = n5 + 1;
                    break;
                }
                String string5 = string.substring(n3 + 1, n);
                string3 = string5 = bl ? string5.replace('/', '.') : string5.substring(string5.lastIndexOf(47) + 1);
                n3 += n + 1;
                break;
            }
            case '+': {
                bl2 = true;
                ++n3;
            }
            case 'T': {
                n = string.indexOf(59, n3 + 1);
                String string6 = string.substring(n3 + 1, n);
                string3 = this.getTypeArgument(string6, classFile, map);
                if (string3 == null) {
                    string3 = "UNKNOWN_GENERIC_TYPE_" + string6;
                } else if (bl2) {
                    string3 = "? extends " + string3;
                }
                n3 = n + 1;
                break;
            }
            case '*': {
                string3 = "?";
                ++n3;
                break;
            }
            default: {
                String string4;
                string3 = string4 = "INVALID_TYPE_" + string;
                n3 += string.length();
            }
        }
        n = 0;
        while (n < n2) {
            string3 = String.valueOf(string3) + "[]";
            ++n;
        }
        return paramDescriptorResult.set(string3, n3);
    }

    public String toString() {
        return "[Signature: signature=" + this.getSignature() + "]";
    }

    private static class ParamDescriptorResult {
        public String type;
        public int pos;

        private ParamDescriptorResult() {
        }

        public ParamDescriptorResult set(String string, int n) {
            this.type = string;
            this.pos = n;
            return this;
        }
    }
}

