/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader.attributes;

import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantDoubleInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantFloatInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantIntegerInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantLongInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantPoolInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantStringInfo;

public class ConstantValue
extends AttributeInfo {
    private int constantValueIndex;

    public ConstantValue(ClassFile classFile, int n) {
        super(classFile);
        this.constantValueIndex = n;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    public String getConstantValueAsString() {
        ClassFile classFile = this.getClassFile();
        ConstantPoolInfo constantPoolInfo = classFile.getConstantPoolInfo(this.getConstantValueIndex());
        if (constantPoolInfo instanceof ConstantDoubleInfo) {
            ConstantDoubleInfo constantDoubleInfo = (ConstantDoubleInfo)constantPoolInfo;
            double d = constantDoubleInfo.getDoubleValue();
            return Double.toString(d);
        }
        if (constantPoolInfo instanceof ConstantFloatInfo) {
            ConstantFloatInfo constantFloatInfo = (ConstantFloatInfo)constantPoolInfo;
            float f = constantFloatInfo.getFloatValue();
            return Float.toString(f);
        }
        if (constantPoolInfo instanceof ConstantIntegerInfo) {
            ConstantIntegerInfo constantIntegerInfo = (ConstantIntegerInfo)constantPoolInfo;
            int n = constantIntegerInfo.getIntValue();
            return Integer.toString(n);
        }
        if (constantPoolInfo instanceof ConstantLongInfo) {
            ConstantLongInfo constantLongInfo = (ConstantLongInfo)constantPoolInfo;
            long l = constantLongInfo.getLongValue();
            return Long.toString(l);
        }
        if (constantPoolInfo instanceof ConstantStringInfo) {
            ConstantStringInfo constantStringInfo = (ConstantStringInfo)constantPoolInfo;
            return constantStringInfo.getStringValue();
        }
        return "INVALID_CONSTANT_TYPE_" + constantPoolInfo.toString();
    }
}

