/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.ExceptionTableEntry;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.Util;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.UnsupportedAttribute;

public class Code
extends AttributeInfo {
    private MethodInfo mi;
    private int maxStack;
    private int maxLocals;
    private int codeLength;
    private ExceptionTableEntry[] exceptionTable;
    private String[] paramNames;
    private List<AttributeInfo> attributes;
    private static final String LINE_NUMBER_TABLE = "LineNumberTable";
    private static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    private static final String LOCAL_VARIABLE_TYPE_TABLE = "LocalVariableTypeTable";
    private static final String STACK_MAP_TABLE = "StackMapTable";

    public Code(MethodInfo methodInfo) {
        super(methodInfo.getClassFile());
        this.mi = methodInfo;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public MethodInfo getMethodInfo() {
        return this.mi;
    }

    public String getParameterName(int n) {
        return this.paramNames == null ? null : this.paramNames[n];
    }

    public static Code read(MethodInfo methodInfo, DataInputStream dataInputStream) throws IOException {
        int n;
        Code code = new Code(methodInfo);
        code.maxStack = dataInputStream.readUnsignedShort();
        code.maxLocals = dataInputStream.readUnsignedShort();
        code.codeLength = dataInputStream.readInt();
        Util.skipBytes(dataInputStream, code.codeLength);
        int n2 = dataInputStream.readUnsignedShort();
        if (n2 > 0) {
            code.exceptionTable = new ExceptionTableEntry[n2];
            n = 0;
            while (n < n2) {
                ExceptionTableEntry exceptionTableEntry;
                code.exceptionTable[n] = exceptionTableEntry = ExceptionTableEntry.read(methodInfo.getClassFile(), dataInputStream);
                ++n;
            }
        }
        if ((n = dataInputStream.readUnsignedShort()) > 0) {
            code.attributes = new ArrayList<AttributeInfo>(1);
            int n3 = 0;
            while (n3 < n) {
                AttributeInfo attributeInfo = code.readAttribute(dataInputStream);
                if (attributeInfo != null) {
                    code.attributes.add(attributeInfo);
                }
                ++n3;
            }
        }
        return code;
    }

    private AttributeInfo readAttribute(DataInputStream dataInputStream) throws IOException {
        UnsupportedAttribute unsupportedAttribute = null;
        ClassFile classFile = this.mi.getClassFile();
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        String string = classFile.getUtf8ValueFromConstantPool(n);
        if (LINE_NUMBER_TABLE.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else if (LOCAL_VARIABLE_TABLE.equals(string)) {
            int n3 = this.mi.getParameterCount();
            this.paramNames = new String[n3];
            boolean bl = this.mi.isStatic();
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                dataInputStream.readUnsignedShort();
                dataInputStream.readUnsignedShort();
                int n7 = dataInputStream.readUnsignedShort();
                dataInputStream.readUnsignedShort();
                int n8 = dataInputStream.readUnsignedShort();
                int n9 = n6 = bl ? n8 : n8 - 1;
                if (n6 >= 0 && n6 < this.paramNames.length) {
                    String string2;
                    this.paramNames[n6] = string2 = classFile.getUtf8ValueFromConstantPool(n7);
                }
                ++n5;
            }
        } else if (LOCAL_VARIABLE_TYPE_TABLE.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else if (STACK_MAP_TABLE.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else {
            System.out.println("Unsupported Code attribute: " + string);
            unsupportedAttribute = AttributeInfo.readUnsupportedAttribute(classFile, dataInputStream, string, n2);
        }
        return unsupportedAttribute;
    }
}

