/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.java.classreader.AccessFlags;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.MemberInfo;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.Code;
import org.fife.rsta.ac.java.classreader.attributes.Exceptions;
import org.fife.rsta.ac.java.classreader.attributes.Signature;

public class MethodInfo
extends MemberInfo
implements AccessFlags {
    private int nameIndex;
    private int descriptorIndex;
    private Signature signatureAttr;
    private Code codeAttr;
    private List<AttributeInfo> attributes;
    private String[] paramTypes;
    private String returnType;
    private String nameAndParameters;
    private static final String SPECIAL_NAME_CONSTRUCTOR = "<init>";
    public static final String CODE = "Code";
    public static final String EXCEPTIONS = "Exceptions";

    public MethodInfo(ClassFile classFile, int n, int n2, int n3) {
        super(classFile, n);
        this.nameIndex = n2;
        this.descriptorIndex = n3;
        this.attributes = new ArrayList<AttributeInfo>(1);
    }

    private void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.add(attributeInfo);
    }

    private void appendParamDescriptors(StringBuilder stringBuilder) {
        String[] stringArray = this.getParameterTypes();
        int n = 0;
        while (n < stringArray.length) {
            stringBuilder.append(stringArray[n]).append(" param").append(n);
            if (n < stringArray.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
    }

    void clearParamTypeInfo() {
        this.paramTypes = null;
        this.returnType = null;
    }

    private String[] createParamTypes() {
        String[] stringArray = this.createParamTypesFromTypeSignature();
        if (stringArray == null) {
            stringArray = this.createParamTypesFromDescriptor(true);
        }
        return stringArray;
    }

    private String[] createParamTypesFromDescriptor(boolean bl) {
        String string = this.getDescriptor();
        int n = string.indexOf(41);
        String string2 = string.substring(1, n);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        while (string2.length() > 0) {
            int n2 = -1;
            while (string2.charAt(++n2) == '[') {
            }
            int n3 = n2;
            switch (string2.charAt(n3)) {
                case 'B': {
                    string3 = "byte";
                    ++n3;
                    break;
                }
                case 'C': {
                    string3 = "char";
                    ++n3;
                    break;
                }
                case 'D': {
                    string3 = "double";
                    ++n3;
                    break;
                }
                case 'F': {
                    string3 = "float";
                    ++n3;
                    break;
                }
                case 'I': {
                    string3 = "int";
                    ++n3;
                    break;
                }
                case 'J': {
                    string3 = "long";
                    ++n3;
                    break;
                }
                case 'S': {
                    string3 = "short";
                    ++n3;
                    break;
                }
                case 'Z': {
                    string3 = "boolean";
                    ++n3;
                    break;
                }
                case 'L': {
                    String string4 = string2.substring(n3 + 1, string2.indexOf(59));
                    string3 = bl ? string4.replace('/', '.') : string4.substring(string4.lastIndexOf(47) + 1);
                    n3 += string4.length() + 2;
                    break;
                }
                default: {
                    String string5;
                    string3 = string5 = "INVALID_TYPE_" + string2;
                    n3 += string2.length();
                }
            }
            int n4 = 0;
            while (n4 < n2) {
                string3 = String.valueOf(string3) + "[]";
                ++n4;
            }
            arrayList.add(string3);
            string2 = string2.substring(n3);
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private String[] createParamTypesFromTypeSignature() {
        List<String> list;
        String[] stringArray = null;
        if (this.signatureAttr != null && (list = this.signatureAttr.getMethodParamTypes(this, this.cf, false)) != null) {
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    public AttributeInfo getAttribute(int n) {
        return this.attributes.get(n);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public String getDescriptor() {
        return this.cf.getUtf8ValueFromConstantPool(this.descriptorIndex);
    }

    @Override
    public String getName() {
        String string = this.cf.getUtf8ValueFromConstantPool(this.nameIndex);
        if (SPECIAL_NAME_CONSTRUCTOR.equals(string)) {
            string = this.cf.getClassName(false);
        }
        return string;
    }

    public String getNameAndParameters() {
        if (this.nameAndParameters == null) {
            StringBuilder stringBuilder = new StringBuilder(this.getName());
            stringBuilder.append('(');
            int n = this.getParameterCount();
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append(this.getParameterType(n2, false));
                if (n2 < n - 1) {
                    stringBuilder.append(", ");
                }
                ++n2;
            }
            stringBuilder.append(')');
            this.nameAndParameters = stringBuilder.toString();
        }
        return this.nameAndParameters;
    }

    public int getParameterCount() {
        if (this.paramTypes == null) {
            this.paramTypes = this.createParamTypes();
        }
        return this.paramTypes.length;
    }

    public String getParameterName(int n) {
        if (n >= 0 && n < this.getParameterCount() && this.codeAttr != null) {
            return this.codeAttr.getParameterName(n);
        }
        return null;
    }

    public String getParameterType(int n, boolean bl) {
        int n2;
        if (this.paramTypes == null) {
            this.paramTypes = this.createParamTypes();
        }
        String string = this.paramTypes[n];
        if (!bl && (n2 = string.lastIndexOf(46)) > -1) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public String[] getParameterTypes() {
        if (this.paramTypes == null) {
            this.paramTypes = this.createParamTypes();
        }
        return (String[])this.paramTypes.clone();
    }

    public String getReturnTypeString(boolean bl) {
        if (this.returnType == null) {
            this.returnType = this.getReturnTypeStringFromTypeSignature(bl);
            if (this.returnType == null) {
                this.returnType = this.getReturnTypeStringFromDescriptor(bl);
            }
        }
        if (!bl && this.returnType != null && this.returnType.indexOf(".") > -1) {
            return this.returnType.substring(this.returnType.lastIndexOf(".") + 1, this.returnType.length());
        }
        return this.returnType;
    }

    private String getReturnTypeStringFromDescriptor(boolean bl) {
        String string = this.getDescriptor();
        int n = string.indexOf(41);
        string = string.substring(n + 1);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.lastIndexOf(91) + 1;
        switch (string.charAt(n2)) {
            case 'B': {
                stringBuilder.append("byte");
                break;
            }
            case 'C': {
                stringBuilder.append("char");
                break;
            }
            case 'D': {
                stringBuilder.append("double");
                break;
            }
            case 'F': {
                stringBuilder.append("float");
                break;
            }
            case 'I': {
                stringBuilder.append("int");
                break;
            }
            case 'J': {
                stringBuilder.append("long");
                break;
            }
            case 'S': {
                stringBuilder.append("short");
                break;
            }
            case 'Z': {
                stringBuilder.append("boolean");
                break;
            }
            case 'V': {
                stringBuilder.append("void");
                break;
            }
            case 'L': {
                String string2 = string.substring(n2 + 1, string.length() - 1);
                string2 = bl ? string2.replace('/', '.') : string2.substring(string2.lastIndexOf(47) + 1);
                stringBuilder.append(string2);
                break;
            }
            default: {
                stringBuilder.append("UNSUPPORTED_TYPE_").append(string);
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append("[]");
            ++n3;
        }
        return stringBuilder.toString();
    }

    private String getReturnTypeStringFromTypeSignature(boolean bl) {
        String string = null;
        if (this.signatureAttr != null) {
            string = this.signatureAttr.getMethodReturnType(this, this.cf, bl);
        }
        return string;
    }

    public String getSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isConstructor()) {
            stringBuilder.append(this.getReturnTypeString(false));
            stringBuilder.append(' ');
        }
        stringBuilder.append(this.getName());
        stringBuilder.append('(');
        this.appendParamDescriptors(stringBuilder);
        stringBuilder.append(')');
        for (AttributeInfo attributeInfo : this.attributes) {
            if (!(attributeInfo instanceof Exceptions)) continue;
            stringBuilder.append(" throws ");
            Exceptions exceptions = (Exceptions)attributeInfo;
            int n = 0;
            while (n < exceptions.getExceptionCount()) {
                stringBuilder.append(exceptions.getException(n));
                if (n < exceptions.getExceptionCount() - 1) {
                    stringBuilder.append(", ");
                }
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) > 0;
    }

    public boolean isConstructor() {
        String string = this.cf.getUtf8ValueFromConstantPool(this.nameIndex);
        return SPECIAL_NAME_CONSTRUCTOR.equals(string);
    }

    public boolean isNative() {
        return (this.getAccessFlags() & 0x100) > 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getAccessFlags() & 8) > 0;
    }

    public static MethodInfo read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        MethodInfo methodInfo = new MethodInfo(classFile, n, n2, n3);
        int n4 = dataInputStream.readUnsignedShort();
        int n5 = 0;
        while (n5 < n4) {
            AttributeInfo attributeInfo = methodInfo.readAttribute(dataInputStream);
            if (attributeInfo instanceof Signature) {
                methodInfo.signatureAttr = (Signature)attributeInfo;
            } else if (attributeInfo instanceof Code) {
                methodInfo.codeAttr = (Code)attributeInfo;
            } else if (attributeInfo != null) {
                methodInfo.addAttribute(attributeInfo);
            }
            ++n5;
        }
        return methodInfo;
    }

    private AttributeInfo readAttribute(DataInputStream dataInputStream) throws IOException {
        AttributeInfo attributeInfo = null;
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        String string = this.cf.getUtf8ValueFromConstantPool(n);
        if (CODE.equals(string)) {
            attributeInfo = Code.read(this, dataInputStream);
        } else if (EXCEPTIONS.equals(string)) {
            int n3 = dataInputStream.readUnsignedShort();
            int[] nArray = null;
            if (n3 > 0) {
                nArray = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = dataInputStream.readUnsignedShort();
                    ++n4;
                }
            }
            Exceptions exceptions = new Exceptions(this, nArray);
            attributeInfo = exceptions;
        } else {
            attributeInfo = super.readAttribute(dataInputStream, string, n2);
        }
        return attributeInfo;
    }
}

