/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.DataInputStream;
import java.io.IOException;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.Util;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.Signature;

public abstract class MemberInfo {
    protected ClassFile cf;
    private int accessFlags;
    private boolean deprecated;
    public static final String DEPRECATED = "Deprecated";
    public static final String SIGNATURE = "Signature";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";

    protected MemberInfo(ClassFile classFile, int n) {
        this.cf = classFile;
        this.accessFlags = n;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public ClassFile getClassFile() {
        return this.cf;
    }

    public abstract String getName();

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public abstract String getDescriptor();

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) > 0;
    }

    protected AttributeInfo readAttribute(DataInputStream dataInputStream, String string, int n) throws IOException {
        AttributeInfo attributeInfo = null;
        if (DEPRECATED.equals(string)) {
            this.deprecated = true;
        } else if (SIGNATURE.equals(string)) {
            int n2 = dataInputStream.readUnsignedShort();
            String string2 = this.cf.getUtf8ValueFromConstantPool(n2);
            attributeInfo = new Signature(this.cf, string2);
        } else if (RUNTIME_VISIBLE_ANNOTATIONS.equals(string)) {
            Util.skipBytes(dataInputStream, n);
        } else {
            attributeInfo = AttributeInfo.readUnsupportedAttribute(this.cf, dataInputStream, string, n);
        }
        return attributeInfo;
    }
}

