/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.util.Stack;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.attributes.Code;

public class Frame {
    private Stack<String> operandStack = new Stack();
    private LocalVarInfo[] localVars;

    public Frame(Code code) {
        this.localVars = new LocalVarInfo[code.getMaxLocals()];
        int n = 0;
        MethodInfo methodInfo = code.getMethodInfo();
        if (!methodInfo.isStatic()) {
            this.localVars[n++] = new LocalVarInfo("this", true);
        }
        String[] stringArray = methodInfo.getParameterTypes();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string.indexOf(46) > -1) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            String string2 = "localVar_" + string + "_" + n2;
            this.localVars[n] = new LocalVarInfo(string2, true);
            ++n;
            if ("long".equals(string) || "double".equals(string)) {
                ++n;
            }
            ++n2;
        }
        System.out.println("NOTE: " + (this.localVars.length - n) + " unknown localVars slots");
    }

    public LocalVarInfo getLocalVar(int n, String string) {
        LocalVarInfo localVarInfo = this.localVars[n];
        if (localVarInfo == null) {
            String string2 = "localVar_" + string + "_" + n;
            this.localVars[n] = localVarInfo = new LocalVarInfo(string2, false);
        } else {
            localVarInfo.alreadyDeclared = true;
        }
        return localVarInfo;
    }

    public String pop() {
        return this.operandStack.pop();
    }

    public void push(String string) {
        this.operandStack.push(string);
    }

    public static class LocalVarInfo {
        private String value;
        private boolean alreadyDeclared;

        public LocalVarInfo(String string, boolean bl) {
            this.value = string;
            this.alreadyDeclared = bl;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isAlreadyDeclared() {
            return this.alreadyDeclared;
        }
    }
}

