/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.MemberInfo;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.ConstantValue;

public class FieldInfo
extends MemberInfo {
    private int nameIndex;
    private int descriptorIndex;
    private List<AttributeInfo> attributes;
    public static final String CONSTANT_VALUE = "ConstantValue";

    public FieldInfo(ClassFile classFile, int n, int n2, int n3) {
        super(classFile, n);
        this.nameIndex = n2;
        this.descriptorIndex = n3;
        this.attributes = new ArrayList<AttributeInfo>(1);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.add(attributeInfo);
    }

    public AttributeInfo getAttribute(int n) {
        return this.attributes.get(n);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getConstantValueAsString() {
        ConstantValue constantValue = this.getConstantValueAttributeInfo();
        return constantValue == null ? null : constantValue.getConstantValueAsString();
    }

    private ConstantValue getConstantValueAttributeInfo() {
        int n = 0;
        while (n < this.getAttributeCount()) {
            AttributeInfo attributeInfo = this.attributes.get(n);
            if (attributeInfo instanceof ConstantValue) {
                return (ConstantValue)attributeInfo;
            }
            ++n;
        }
        return null;
    }

    @Override
    public String getDescriptor() {
        return this.cf.getUtf8ValueFromConstantPool(this.descriptorIndex);
    }

    @Override
    public String getName() {
        return this.cf.getUtf8ValueFromConstantPool(this.nameIndex);
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public String getTypeString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getDescriptor();
        int n = string.lastIndexOf(91) + 1;
        switch (string.charAt(n)) {
            case 'B': {
                stringBuilder.append("byte");
                break;
            }
            case 'C': {
                stringBuilder.append("char");
                break;
            }
            case 'D': {
                stringBuilder.append("double");
                break;
            }
            case 'F': {
                stringBuilder.append("float");
                break;
            }
            case 'I': {
                stringBuilder.append("int");
                break;
            }
            case 'J': {
                stringBuilder.append("long");
                break;
            }
            case 'S': {
                stringBuilder.append("short");
                break;
            }
            case 'Z': {
                stringBuilder.append("boolean");
                break;
            }
            case 'L': {
                String string2 = string.substring(n + 1, string.length() - 1);
                string2 = bl ? string2.replace('/', '.') : string2.substring(string2.lastIndexOf(47) + 1);
                stringBuilder.append(string2);
                break;
            }
            default: {
                stringBuilder.append("UNSUPPORTED_TYPE_").append(string);
            }
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("[]");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public boolean isConstant() {
        return this.getConstantValueAttributeInfo() != null;
    }

    public static FieldInfo read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        FieldInfo fieldInfo = new FieldInfo(classFile, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
        int n = dataInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            AttributeInfo attributeInfo = fieldInfo.readAttribute(dataInputStream);
            if (attributeInfo != null) {
                fieldInfo.addAttribute(attributeInfo);
            }
            ++n2;
        }
        return fieldInfo;
    }

    private AttributeInfo readAttribute(DataInputStream dataInputStream) throws IOException {
        AttributeInfo attributeInfo = null;
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        String string = this.cf.getUtf8ValueFromConstantPool(n);
        if (CONSTANT_VALUE.equals(string)) {
            int n3 = dataInputStream.readUnsignedShort();
            ConstantValue constantValue = new ConstantValue(this.cf, n3);
            attributeInfo = constantValue;
        } else {
            attributeInfo = super.readAttribute(dataInputStream, string, n2);
        }
        return attributeInfo;
    }
}

