/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.DataInputStream;
import java.io.IOException;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class ExceptionTableEntry {
    private ClassFile cf;
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchType;

    public ExceptionTableEntry(ClassFile classFile) {
        this.cf = classFile;
    }

    public String getCaughtThrowableType(boolean bl) {
        return this.catchType == 0 ? null : this.cf.getClassNameFromConstantPool(this.catchType, bl);
    }

    public int getEndPC() {
        return this.endPC;
    }

    public int getHandlerPC() {
        return this.handlerPC;
    }

    public int getStartPC() {
        return this.startPC;
    }

    public static ExceptionTableEntry read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(classFile);
        exceptionTableEntry.startPC = dataInputStream.readUnsignedShort();
        exceptionTableEntry.endPC = dataInputStream.readUnsignedShort();
        exceptionTableEntry.handlerPC = dataInputStream.readUnsignedShort();
        exceptionTableEntry.catchType = dataInputStream.readUnsignedShort();
        return exceptionTableEntry;
    }
}

