/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.classreader;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fife.rsta.ac.java.classreader.AccessFlags;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.classreader.Util;
import org.fife.rsta.ac.java.classreader.attributes.AttributeInfo;
import org.fife.rsta.ac.java.classreader.attributes.Signature;
import org.fife.rsta.ac.java.classreader.attributes.SourceFile;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantClassInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantDoubleInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantLongInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantPoolInfo;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantPoolInfoFactory;
import org.fife.rsta.ac.java.classreader.constantpool.ConstantUtf8Info;

public class ClassFile
implements AccessFlags {
    private static final boolean DEBUG = false;
    private int minorVersion;
    private int majorVersion;
    private ConstantPoolInfo[] constantPool;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    int[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private boolean deprecated;
    private AttributeInfo[] attributes;
    private List<String> paramTypes;
    private Map<String, String> typeMap;
    public static final String DEPRECATED = "Deprecated";
    public static final String ENCLOSING_METHOD = "EnclosingMethod";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String SIGNATURE = "Signature";
    public static final String SOURCE_FILE = "SourceFile";
    private static final byte[] HEADER = new byte[]{-54, -2, -70, -66};

    public ClassFile(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.init(dataInputStream);
        }
        finally {
            dataInputStream.close();
        }
    }

    public ClassFile(DataInputStream dataInputStream) throws IOException {
        this.init(dataInputStream);
    }

    private void debugPrint(String string) {
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public AttributeInfo getAttribute(int n) {
        return this.attributes[n];
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.length;
    }

    public String getClassName(boolean bl) {
        return this.getClassNameFromConstantPool(this.thisClass, bl);
    }

    protected String getClassNameFromConstantPool(int n, boolean bl) {
        ConstantPoolInfo constantPoolInfo = this.getConstantPoolInfo(n);
        if (constantPoolInfo instanceof ConstantClassInfo) {
            ConstantClassInfo constantClassInfo = (ConstantClassInfo)constantPoolInfo;
            int n2 = constantClassInfo.getNameIndex();
            ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.getConstantPoolInfo(n2);
            String string = constantUtf8Info.getRepresentedString(false);
            string = bl ? string.replace('/', '.') : string.substring(string.lastIndexOf(47) + 1);
            return string.replace('$', '.');
        }
        throw new InternalError("Expected ConstantClassInfo, found " + constantPoolInfo.getClass().toString());
    }

    public int getConstantPoolCount() {
        return this.constantPool.length + 1;
    }

    public ConstantPoolInfo getConstantPoolInfo(int n) {
        return n != 0 ? this.constantPool[n - 1] : null;
    }

    public int getFieldCount() {
        return this.fields == null ? 0 : this.fields.length;
    }

    public FieldInfo getFieldInfo(int n) {
        return this.fields[n];
    }

    public FieldInfo getFieldInfoByName(String string) {
        int n = 0;
        while (n < this.getFieldCount()) {
            if (string.equals(this.fields[n].getName())) {
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    public int getImplementedInterfaceCount() {
        return this.interfaces == null ? 0 : this.interfaces.length;
    }

    public String getImplementedInterfaceName(int n, boolean bl) {
        return this.getClassNameFromConstantPool(this.interfaces[n], bl);
    }

    public int getMethodCount() {
        return this.methods == null ? 0 : this.methods.length;
    }

    public MethodInfo getMethodInfo(int n) {
        return this.methods[n];
    }

    public List<MethodInfo> getMethodInfoByName(String string) {
        return this.getMethodInfoByName(string, -1);
    }

    public List<MethodInfo> getMethodInfoByName(String string, int n) {
        ArrayList<MethodInfo> arrayList = null;
        int n2 = 0;
        while (n2 < this.getMethodCount()) {
            MethodInfo methodInfo = this.methods[n2];
            if (string.equals(methodInfo.getName()) && (n < 0 || n == methodInfo.getParameterCount())) {
                if (arrayList == null) {
                    arrayList = new ArrayList<MethodInfo>(1);
                }
                arrayList.add(methodInfo);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getPackageName() {
        String string = this.getClassName(true);
        int n = string.lastIndexOf(46);
        return n == -1 ? null : string.substring(0, n);
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public String getSuperClassName(boolean bl) {
        if (this.superClass == 0) {
            return null;
        }
        return this.getClassNameFromConstantPool(this.superClass, bl);
    }

    public String getTypeArgument(String string) {
        return this.typeMap == null ? "Object" : this.typeMap.get(string);
    }

    public String getUtf8ValueFromConstantPool(int n) {
        ConstantPoolInfo constantPoolInfo = this.getConstantPoolInfo(n);
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfo;
        return constantUtf8Info.getRepresentedString(false);
    }

    public String getVersionString() {
        return String.valueOf(this.majorVersion) + "." + this.minorVersion;
    }

    private void init(DataInputStream dataInputStream) throws IOException {
        this.readHeader(dataInputStream);
        this.readVersion(dataInputStream);
        this.readConstantPoolInfos(dataInputStream);
        this.readAccessFlags(dataInputStream);
        this.readThisClass(dataInputStream);
        this.readSuperClass(dataInputStream);
        this.readInterfaces(dataInputStream);
        this.readFields(dataInputStream);
        this.readMethods(dataInputStream);
        this.readAttributes(dataInputStream);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    private void readAccessFlags(DataInputStream dataInputStream) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.debugPrint("Access flags: " + this.accessFlags);
    }

    private AttributeInfo readAttribute(DataInputStream dataInputStream) throws IOException {
        AttributeInfo attributeInfo = null;
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        String string = this.getUtf8ValueFromConstantPool(n);
        this.debugPrint("Found class attribute: " + string);
        if (SOURCE_FILE.equals(string)) {
            SourceFile sourceFile;
            int n3 = dataInputStream.readUnsignedShort();
            attributeInfo = sourceFile = new SourceFile(this, n3);
        } else if (SIGNATURE.equals(string)) {
            int n4 = dataInputStream.readUnsignedShort();
            String string2 = this.getUtf8ValueFromConstantPool(n4);
            attributeInfo = new Signature(this, string2);
            this.paramTypes = ((Signature)attributeInfo).getClassParamTypes();
        } else if (INNER_CLASSES.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else if (ENCLOSING_METHOD.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else if (DEPRECATED.equals(string)) {
            this.deprecated = true;
        } else if (RUNTIME_VISIBLE_ANNOTATIONS.equals(string)) {
            Util.skipBytes(dataInputStream, n2);
        } else {
            System.out.println("Unsupported class attribute: " + string);
            attributeInfo = AttributeInfo.readUnsupportedAttribute(this, dataInputStream, string, n2);
        }
        return attributeInfo;
    }

    private void readAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        if (n > 0) {
            this.attributes = new AttributeInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.attributes[n2] = this.readAttribute(dataInputStream);
                ++n2;
            }
        }
    }

    private void readConstantPoolInfos(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort() - 1;
        this.debugPrint("Constant pool count: " + n);
        this.constantPool = new ConstantPoolInfo[n];
        int n2 = 0;
        while (n2 < n) {
            ConstantPoolInfo constantPoolInfo;
            this.constantPool[n2] = constantPoolInfo = ConstantPoolInfoFactory.readConstantPoolInfo(this, dataInputStream);
            if (constantPoolInfo instanceof ConstantLongInfo || constantPoolInfo instanceof ConstantDoubleInfo) {
                ++n2;
            }
            ++n2;
        }
    }

    private void readFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        if (n > 0) {
            this.fields = new FieldInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.fields[n2] = FieldInfo.read(this, dataInputStream);
                ++n2;
            }
        }
        this.debugPrint("fieldCount: " + n);
    }

    private void readHeader(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        while (n < HEADER.length) {
            byte by = dataInputStream.readByte();
            if (by != HEADER[n]) {
                throw new IOException("\"CAFEBABE\" header not found");
            }
            ++n;
        }
    }

    private void readInterfaces(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        if (n > 0) {
            this.interfaces = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.interfaces[n2] = dataInputStream.readUnsignedShort();
                ++n2;
            }
        }
        this.debugPrint("interfaceCount: " + n);
    }

    private void readMethods(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        if (n > 0) {
            this.methods = new MethodInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.methods[n2] = MethodInfo.read(this, dataInputStream);
                ++n2;
            }
        }
    }

    private void readSuperClass(DataInputStream dataInputStream) throws IOException {
        this.superClass = dataInputStream.readUnsignedShort();
        ConstantPoolInfo constantPoolInfo = this.getConstantPoolInfo(this.superClass);
        this.debugPrint("superClass: " + constantPoolInfo);
    }

    private void readThisClass(DataInputStream dataInputStream) throws IOException {
        this.thisClass = dataInputStream.readUnsignedShort();
        ConstantPoolInfo constantPoolInfo = this.getConstantPoolInfo(this.thisClass);
        this.debugPrint("thisClass: " + constantPoolInfo);
    }

    private void readVersion(DataInputStream dataInputStream) throws IOException {
        this.minorVersion = dataInputStream.readUnsignedShort();
        this.majorVersion = dataInputStream.readUnsignedShort();
        this.debugPrint("Class file version: " + this.getVersionString());
    }

    public void setTypeParamsToTypeArgs(Map<String, String> map) {
        this.typeMap = map;
        int n = 0;
        while (n < this.getMethodCount()) {
            this.getMethodInfo(n).clearParamTypeInfo();
            ++n;
        }
    }

    public String toString() {
        return "[ClassFile: accessFlags=" + this.accessFlags + "]";
    }
}

