/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.lexer.Scanner;
import org.fife.rsta.ac.java.rjc.parser.ASTFactory;

public class ZipSourceLocation
implements SourceLocation {
    private File archive;

    public ZipSourceLocation(String string) {
        this(new File(string));
    }

    public ZipSourceLocation(File file) {
        this.archive = file;
    }

    @Override
    public CompilationUnit getCompilationUnit(ClassFile classFile) throws IOException {
        CompilationUnit compilationUnit = null;
        ZipFile zipFile = new ZipFile(this.archive);
        try {
            String string = classFile.getClassName(true).replaceAll("\\.", "/");
            string = String.valueOf(string) + ".java";
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                zipEntry = zipFile.getEntry("src/" + string);
            }
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Scanner scanner = new Scanner(new InputStreamReader(inputStream));
                compilationUnit = new ASTFactory().getCompilationUnit(string, scanner);
            }
        }
        finally {
            zipFile.close();
        }
        return compilationUnit;
    }

    @Override
    public String getLocationAsString() {
        return this.archive.getAbsolutePath();
    }
}

