/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.fife.rsta.ac.java.buildpath.JarLibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.buildpath.ZipSourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public abstract class LibraryInfo
implements Comparable,
Cloneable {
    private SourceLocation sourceLoc;

    public abstract void bulkClassFileCreationEnd() throws IOException;

    public abstract void bulkClassFileCreationStart() throws IOException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Doesn't support cloning, but should! - " + this.getClass().getName());
        }
    }

    public abstract ClassFile createClassFile(String var1) throws IOException;

    public abstract ClassFile createClassFileBulk(String var1) throws IOException;

    public abstract TreeMap createPackageMap() throws IOException;

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static LibraryInfo getJreJarInfo(File file) {
        JarLibraryInfo jarLibraryInfo = null;
        File file2 = new File(file, "jre/lib/rt.jar");
        if (!file2.isFile()) {
            file2 = new File(file, "lib/rt.jar");
        }
        if (!file2.isFile()) {
            file2 = new File(file, "Classes/classes.jar");
        }
        if (!file2.isFile()) {
            file2 = new File(file, "../Classes/classes.jar");
        }
        if (file2.isFile()) {
            File file3 = new File(file, "src.zip");
            if (!file3.isFile()) {
                file3 = new File(file, "../src.zip");
            }
            if (!file3.isFile()) {
                file3 = new File(file, "Home/src.jar");
            }
            if (!file3.isFile()) {
                file3 = new File(file, "src.jar");
            }
            jarLibraryInfo = new JarLibraryInfo(file2);
            if (file3.isFile()) {
                jarLibraryInfo.setSourceLocation(new ZipSourceLocation(file3));
            } else {
                System.err.println("Unable to locate JDK sources. Please add JDK [Settings -> Java]. ");
            }
        } else {
            System.err.println("[ERROR]: Cannot locate JRE jar in " + file.getAbsolutePath());
            file2 = null;
        }
        return jarLibraryInfo;
    }

    public abstract long getLastModified();

    public abstract String getLocationAsString();

    public static LibraryInfo getMainJreJarInfo() {
        String string = System.getProperty("asaf.java.home");
        return LibraryInfo.getJreJarInfo(new File(string));
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    public abstract int hashCode();

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLoc = sourceLocation;
    }
}

