/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class JarLibraryInfo
extends LibraryInfo {
    private File jarFile;
    private JarFile bulkCreateJar;

    public JarLibraryInfo(String string) {
        this(new File(string));
    }

    public JarLibraryInfo(File file) {
        this(file, null);
    }

    public JarLibraryInfo(File file, SourceLocation sourceLocation) {
        this.setJarFile(file);
        this.setSourceLocation(sourceLocation);
    }

    @Override
    public void bulkClassFileCreationEnd() {
        try {
            this.bulkCreateJar.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void bulkClassFileCreationStart() {
        try {
            this.bulkCreateJar = new JarFile(this.jarFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        int n = -1;
        if (object instanceof JarLibraryInfo) {
            n = this.jarFile.compareTo(((JarLibraryInfo)object).jarFile);
        }
        return n;
    }

    @Override
    public ClassFile createClassFile(String string) throws IOException {
        JarFile jarFile = new JarFile(this.jarFile);
        try {
            ClassFile classFile = JarLibraryInfo.createClassFileImpl(jarFile, string);
            return classFile;
        }
        finally {
            jarFile.close();
        }
    }

    @Override
    public ClassFile createClassFileBulk(String string) throws IOException {
        return JarLibraryInfo.createClassFileImpl(this.bulkCreateJar, string);
    }

    private static final ClassFile createClassFileImpl(JarFile jarFile, String string) throws IOException {
        JarEntry jarEntry = (JarEntry)jarFile.getEntry(string);
        if (jarEntry == null) {
            System.err.println("ERROR: Invalid entry: " + string);
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(jarEntry)));
        ClassFile classFile = null;
        try {
            classFile = new ClassFile(dataInputStream);
        }
        finally {
            dataInputStream.close();
        }
        return classFile;
    }

    @Override
    public TreeMap createPackageMap() throws IOException {
        TreeMap treeMap = new TreeMap();
        JarFile jarFile = new JarFile(this.jarFile);
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.endsWith(".class")) continue;
                string = string.substring(0, string.length() - 6);
                String[] stringArray = Util.splitOnChar(string, 47);
                TreeMap treeMap2 = treeMap;
                int n = 0;
                while (n < stringArray.length - 1) {
                    TreeMap treeMap3 = (TreeMap)treeMap2.get(stringArray[n]);
                    if (treeMap3 == null) {
                        treeMap3 = new TreeMap();
                        treeMap2.put(stringArray[n], treeMap3);
                    }
                    treeMap2 = treeMap3;
                    ++n;
                }
                String string2 = stringArray[stringArray.length - 1];
                treeMap2.put(string2, null);
            }
        }
        finally {
            jarFile.close();
        }
        return treeMap;
    }

    @Override
    public long getLastModified() {
        return this.jarFile.lastModified();
    }

    @Override
    public String getLocationAsString() {
        return this.jarFile.getAbsolutePath();
    }

    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public int hashCode() {
        return this.jarFile.hashCode();
    }

    private void setJarFile(File file) {
        if (file == null || !file.exists()) {
            String string = file == null ? "null" : file.getAbsolutePath();
            throw new IllegalArgumentException("Jar does not exist: " + string);
        }
        this.jarFile = file;
    }

    public String toString() {
        return "[JarLibraryInfo: jar=" + this.jarFile.getAbsolutePath() + "; source=" + this.getSourceLocation() + "]";
    }
}

