/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.lexer.Scanner;
import org.fife.rsta.ac.java.rjc.parser.ASTFactory;

public class DirSourceLocation
implements SourceLocation {
    private File dir;

    public DirSourceLocation(String string) {
        this(new File(string));
    }

    public DirSourceLocation(File file) {
        this.dir = file;
    }

    @Override
    public CompilationUnit getCompilationUnit(ClassFile classFile) throws IOException {
        CompilationUnit compilationUnit = null;
        String string = classFile.getClassName(true);
        string = string.replace('.', '/');
        File file = new File(this.dir, string = String.valueOf(string) + ".java");
        if (!file.isFile()) {
            file = new File(this.dir, "src/" + string);
        }
        if (file.isFile()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                Scanner scanner = new Scanner(bufferedReader);
                compilationUnit = new ASTFactory().getCompilationUnit(string, scanner);
            }
            finally {
                bufferedReader.close();
            }
        }
        return compilationUnit;
    }

    @Override
    public String getLocationAsString() {
        return this.dir.getAbsolutePath();
    }
}

