/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class DirLibraryInfo
extends LibraryInfo {
    private File dir;

    public DirLibraryInfo(File file) {
        this(file, null);
    }

    public DirLibraryInfo(String string) {
        this(new File(string));
    }

    public DirLibraryInfo(File file, SourceLocation sourceLocation) {
        this.setDirectory(file);
        this.setSourceLocation(sourceLocation);
    }

    public DirLibraryInfo(String string, SourceLocation sourceLocation) {
        this(new File(string), sourceLocation);
    }

    @Override
    public void bulkClassFileCreationEnd() {
    }

    @Override
    public void bulkClassFileCreationStart() {
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        int n = -1;
        if (object instanceof DirLibraryInfo) {
            return this.dir.compareTo(((DirLibraryInfo)object).dir);
        }
        return n;
    }

    @Override
    public ClassFile createClassFile(String string) throws IOException {
        return this.createClassFileBulk(string);
    }

    @Override
    public ClassFile createClassFileBulk(String string) throws IOException {
        File file = new File(this.dir, string);
        if (!file.isFile()) {
            System.err.println("ERROR: Invalid class file: " + file.getAbsolutePath());
            return null;
        }
        return new ClassFile(file);
    }

    @Override
    public TreeMap createPackageMap() throws IOException {
        TreeMap treeMap = new TreeMap();
        this.getPackageMapImpl(this.dir, null, treeMap);
        return treeMap;
    }

    @Override
    public long getLastModified() {
        return this.dir.lastModified();
    }

    @Override
    public String getLocationAsString() {
        return this.dir.getAbsolutePath();
    }

    private void getPackageMapImpl(File file, String string, TreeMap treeMap) throws IOException {
        File[] fileArray = file.listFiles();
        TreeMap treeMap2 = treeMap;
        boolean bl = true;
        int n = 0;
        while (n < fileArray.length) {
            Object object;
            File file2 = fileArray[n];
            if (file2.isFile() && file2.getName().endsWith(".class")) {
                if (string != null && bl) {
                    bl = false;
                    object = Util.splitOnChar(string, 47);
                    int n2 = 0;
                    while (n2 < ((String[])object).length) {
                        Object v = treeMap2.get(object[n2]);
                        if (v instanceof TreeMap) {
                            treeMap2 = (TreeMap)v;
                        } else if (v == null) {
                            TreeMap treeMap3 = new TreeMap();
                            treeMap2.put(object[n2], treeMap3);
                            treeMap2 = treeMap3;
                        } else {
                            return;
                        }
                        ++n2;
                    }
                }
                object = file2.getName().substring(0, file2.getName().length() - 6);
                treeMap2.put(object, null);
            } else if (file2.isDirectory()) {
                object = string == null ? file2.getName() : String.valueOf(string) + "/" + file2.getName();
                this.getPackageMapImpl(file2, (String)object, treeMap);
            }
            ++n;
        }
    }

    @Override
    public int hashCode() {
        return this.dir.hashCode();
    }

    private void setDirectory(File file) {
        if (file == null || !file.isDirectory()) {
            String string = file == null ? "null" : file.getAbsolutePath();
            throw new IllegalArgumentException("Directory does not exist: " + string);
        }
        this.dir = file;
    }

    public String toString() {
        return "[DirLibraryInfo: jar=" + this.dir.getAbsolutePath() + "; source=" + this.getSourceLocation() + "]";
    }
}

