/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class ClasspathLibraryInfo
extends LibraryInfo {
    private Map<String, ClassFile> classNameToClassFile;

    public ClasspathLibraryInfo(String[] stringArray) {
        this(Arrays.asList(stringArray), null);
    }

    public ClasspathLibraryInfo(List<String> list) {
        this(list, null);
    }

    public ClasspathLibraryInfo(List<String> list, SourceLocation sourceLocation) {
        this.setSourceLocation(sourceLocation);
        this.classNameToClassFile = new HashMap<String, ClassFile>();
        int n = list == null ? 0 : list.size();
        int n2 = 0;
        while (n2 < n) {
            String string = list.get(n2);
            string = String.valueOf(string.replace('.', '/')) + ".class";
            this.classNameToClassFile.put(string, null);
            ++n2;
        }
    }

    @Override
    public void bulkClassFileCreationEnd() {
    }

    @Override
    public void bulkClassFileCreationStart() {
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        int n = -1;
        if (object instanceof ClasspathLibraryInfo) {
            ClasspathLibraryInfo classpathLibraryInfo = (ClasspathLibraryInfo)object;
            n = this.classNameToClassFile.size() - classpathLibraryInfo.classNameToClassFile.size();
            if (n == 0) {
                for (String string : this.classNameToClassFile.keySet()) {
                    if (classpathLibraryInfo.classNameToClassFile.containsKey(string)) continue;
                    n = -1;
                    break;
                }
            }
        }
        return n;
    }

    @Override
    public ClassFile createClassFile(String string) throws IOException {
        return this.createClassFileBulk(string);
    }

    @Override
    public ClassFile createClassFileBulk(String string) throws IOException {
        ClassFile classFile = null;
        if (this.classNameToClassFile.containsKey(string) && (classFile = this.classNameToClassFile.get(string)) == null) {
            classFile = this.createClassFileImpl(string);
            this.classNameToClassFile.put(string, classFile);
        }
        return classFile;
    }

    private ClassFile createClassFileImpl(String string) throws IOException {
        ClassFile classFile = null;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            DataInputStream dataInputStream = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                dataInputStream = new DataInputStream(bufferedInputStream);
                classFile = new ClassFile(dataInputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return classFile;
    }

    @Override
    public TreeMap createPackageMap() throws IOException {
        TreeMap treeMap = new TreeMap();
        for (String string : this.classNameToClassFile.keySet()) {
            String[] stringArray = Util.splitOnChar(string, 47);
            TreeMap treeMap2 = treeMap;
            int n = 0;
            while (n < stringArray.length - 1) {
                String string2 = stringArray[n];
                TreeMap treeMap3 = (TreeMap)treeMap2.get(string2);
                if (treeMap3 == null) {
                    treeMap3 = new TreeMap();
                    treeMap2.put(string2, treeMap3);
                }
                treeMap2 = treeMap3;
                ++n;
            }
            string = stringArray[stringArray.length - 1];
            string = string.substring(0, string.length() - 6);
            treeMap2.put(string, null);
        }
        return treeMap;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public String getLocationAsString() {
        return null;
    }

    @Override
    public int hashCode() {
        return this.classNameToClassFile.hashCode();
    }
}

