/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.FieldCompletion;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.JavaSourceCompletion;
import org.fife.rsta.ac.java.LocalVariableCompletion;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.rjc.ast.ASTNode;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.NormalClassDeclaration;
import org.fife.rsta.ac.java.rjc.ast.NormalInterfaceDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.EmptyIcon;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class SourceParamChoicesProvider
implements ParameterChoicesProvider {
    private CompletionProvider provider;

    SourceParamChoicesProvider() {
    }

    private void addPublicAndProtectedFieldsAndGetters(Type type, JarManager jarManager, Package package_, List<Completion> list) {
    }

    public List<Completion> getLocalVarsFieldsAndGetters(NormalClassDeclaration normalClassDeclaration, String string, int n) {
        Object object;
        ASTNode aSTNode;
        Iterator<ASTNode> iterator;
        ArrayList<Completion> arrayList = new ArrayList<Completion>();
        if (!normalClassDeclaration.getBodyContainsOffset(n)) {
            return arrayList;
        }
        Method method = normalClassDeclaration.getMethodContainingOffset(n);
        if (method != null) {
            iterator = method.getParameterIterator();
            while (iterator.hasNext()) {
                aSTNode = (FormalParameter)iterator.next();
                object = ((LocalVariable)aSTNode).getType();
                if (!this.isTypeCompatible((Type)object, string)) continue;
                arrayList.add(new LocalVariableCompletion(this.provider, (LocalVariable)aSTNode));
            }
            aSTNode = method.getBody();
            if (aSTNode != null) {
                object = ((CodeBlock)aSTNode).getDeepestCodeBlockContaining(n);
                List<LocalVariable> list = ((CodeBlock)object).getLocalVarsBefore(n);
                for (LocalVariable localVariable : list) {
                    Type type = localVariable.getType();
                    if (!this.isTypeCompatible(type, string)) continue;
                    arrayList.add(new LocalVariableCompletion(this.provider, localVariable));
                }
            }
        }
        iterator = normalClassDeclaration.getMemberIterator();
        while (iterator.hasNext()) {
            aSTNode = (Member)iterator.next();
            if (aSTNode instanceof Field) {
                object = aSTNode.getType();
                if (!this.isTypeCompatible((Type)object, string)) continue;
                arrayList.add(new FieldCompletion(this.provider, (Field)aSTNode));
                continue;
            }
            method = (Method)aSTNode;
            if (!this.isSimpleGetter(method) || !this.isTypeCompatible(method.getType(), string)) continue;
            arrayList.add(new MethodCompletion(this.provider, method));
        }
        return arrayList;
    }

    @Override
    public List<Completion> getParameterChoices(JTextComponent jTextComponent, ParameterizedCompletion.Parameter parameter) {
        Type type;
        Object object;
        LanguageSupportFactory languageSupportFactory = LanguageSupportFactory.get();
        LanguageSupport languageSupport = languageSupportFactory.getSupportFor("text/java");
        JavaLanguageSupport javaLanguageSupport = (JavaLanguageSupport)languageSupport;
        JarManager jarManager = javaLanguageSupport.getJarManager();
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
        JavaParser javaParser = javaLanguageSupport.getParser(rSyntaxTextArea);
        if (javaParser == null) {
            return null;
        }
        CompilationUnit compilationUnit = javaParser.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        int n = jTextComponent.getCaretPosition();
        TypeDeclaration typeDeclaration = compilationUnit.getDeepestTypeDeclarationAtOffset(n);
        if (typeDeclaration == null) {
            return null;
        }
        List<Completion> list = null;
        Package package_ = typeDeclaration.getPackage();
        this.provider = javaLanguageSupport.getCompletionProvider(rSyntaxTextArea);
        if (typeDeclaration instanceof NormalClassDeclaration) {
            object = (NormalClassDeclaration)typeDeclaration;
            list = this.getLocalVarsFieldsAndGetters((NormalClassDeclaration)object, parameter.getType(), n);
            type = ((NormalClassDeclaration)object).getExtendedType();
            if (type != null) {
                this.addPublicAndProtectedFieldsAndGetters(type, jarManager, package_, list);
            }
            Iterator<Type> iterator = ((NormalClassDeclaration)object).getImplementedIterator();
            while (iterator.hasNext()) {
                Type type2 = iterator.next();
                this.addPublicAndProtectedFieldsAndGetters(type2, jarManager, package_, list);
            }
        } else {
            boolean cfr_ignored_0 = typeDeclaration instanceof NormalInterfaceDeclaration;
        }
        typeDeclaration.isStatic();
        object = parameter.getTypeObject();
        if (object instanceof Type) {
            type = (Type)object;
            if (type.isBasicType()) {
                if (this.isPrimitiveNumericType(type)) {
                    list.add(new SimpleCompletion(this.provider, "0"));
                } else {
                    list.add(new SimpleCompletion(this.provider, "false"));
                    list.add(new SimpleCompletion(this.provider, "true"));
                }
            } else {
                list.add(new SimpleCompletion(this.provider, "null"));
            }
        }
        return list;
    }

    private boolean isPrimitiveNumericType(Type type) {
        String string = type.getName(true);
        return "byte".equals(string) || "float".equals(string) || "double".equals(string) || "int".equals(string) || "short".equals(string) || "long".equals(string);
    }

    private boolean isSimpleGetter(Method method) {
        return method.getParameterCount() == 0 && method.getName().startsWith("get");
    }

    private boolean isTypeCompatible(Type type, String string) {
        String string2 = type.getName(false);
        int n = string2.indexOf(60);
        if (n > -1) {
            String string3 = null;
            int n2 = string2.indexOf(91, n);
            if (n2 > -1) {
                string3 = string2.substring(n2);
            }
            string2 = string2.substring(n);
            if (string3 != null) {
                string2 = String.valueOf(string2) + string3;
            }
        }
        return string2.equalsIgnoreCase(string);
    }

    private static class SimpleCompletion
    extends BasicCompletion
    implements JavaSourceCompletion {
        private Icon ICON = new EmptyIcon(16);

        public SimpleCompletion(CompletionProvider completionProvider, String string) {
            super(completionProvider, string);
            this.setRelevance(-1);
        }

        @Override
        public Icon getIcon() {
            return this.ICON;
        }

        @Override
        public void rendererText(Graphics graphics, int n, int n2, boolean bl) {
        }
    }
}

