/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Cursor;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.ShorthandCompletionCache;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.FieldCompletion;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaCompletionProvider;
import org.fife.rsta.ac.java.LocalVariableCompletion;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.SourceParamChoicesProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.classreader.MemberInfo;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.AbstractASTNode;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.NormalClassDeclaration;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.rsta.ac.java.rjc.lang.TypeArgument;
import org.fife.rsta.ac.java.rjc.lang.TypeParameter;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

class SourceCompletionProvider
extends DefaultCompletionProvider {
    private JavaCompletionProvider javaProvider;
    private JarManager jarManager;
    private static final String JAVA_LANG_PACKAGE = "java.lang.*";
    private static final String THIS = "this";
    private ShorthandCompletionCache shorthandCache;

    public SourceCompletionProvider() {
        this((JarManager)null);
    }

    public SourceCompletionProvider(JarManager jarManager) {
        if (jarManager == null) {
            jarManager = new JarManager();
        }
        this.jarManager = jarManager;
        this.setParameterizedCompletionParams('(', ", ", ')');
        this.setAutoActivationRules(false, ".");
        this.setParameterChoicesProvider(new SourceParamChoicesProvider());
    }

    private void addCompletionsForStaticMembers(Set<Completion> set, CompilationUnit compilationUnit, ClassFile classFile, String string) {
        Object object;
        int n = classFile.getMethodCount();
        int n2 = 0;
        while (n2 < n) {
            MethodInfo methodInfo = classFile.getMethodInfo(n2);
            if (this.isAccessible(methodInfo, string) && methodInfo.isStatic()) {
                object = new MethodCompletion((CompletionProvider)this, methodInfo);
                set.add((Completion)object);
            }
            ++n2;
        }
        n2 = classFile.getFieldCount();
        int n3 = 0;
        while (n3 < n2) {
            object = classFile.getFieldInfo(n3);
            if (this.isAccessible((MemberInfo)object, string) && ((MemberInfo)object).isStatic()) {
                FieldCompletion fieldCompletion = new FieldCompletion((CompletionProvider)this, (FieldInfo)object);
                set.add(fieldCompletion);
            }
            ++n3;
        }
        ClassFile classFile2 = this.getClassFileFor(compilationUnit, classFile.getSuperClassName(true));
        if (classFile2 != null) {
            this.addCompletionsForStaticMembers(set, compilationUnit, classFile2, string);
        }
    }

    private void addCompletionsForExtendedClass(Set<Completion> set, CompilationUnit compilationUnit, ClassFile classFile, String string, Map<String, String> map) {
        Object object;
        Object object2;
        classFile.setTypeParamsToTypeArgs(map);
        int n = classFile.getMethodCount();
        int n2 = 0;
        while (n2 < n) {
            MethodInfo methodInfo = classFile.getMethodInfo(n2);
            if (this.isAccessible(methodInfo, string) && !methodInfo.isConstructor()) {
                object2 = new MethodCompletion((CompletionProvider)this, methodInfo);
                set.add((Completion)object2);
            }
            ++n2;
        }
        n2 = classFile.getFieldCount();
        int n3 = 0;
        while (n3 < n2) {
            object2 = classFile.getFieldInfo(n3);
            if (this.isAccessible((MemberInfo)object2, string)) {
                object = new FieldCompletion((CompletionProvider)this, (FieldInfo)object2);
                set.add((Completion)object);
            }
            ++n3;
        }
        ClassFile classFile2 = this.getClassFileFor(compilationUnit, classFile.getSuperClassName(true));
        if (classFile2 != null) {
            this.addCompletionsForExtendedClass(set, compilationUnit, classFile2, string, map);
        }
        int n4 = 0;
        while (n4 < classFile.getImplementedInterfaceCount()) {
            object = classFile.getImplementedInterfaceName(n4, true);
            classFile = this.getClassFileFor(compilationUnit, (String)object);
            this.addCompletionsForExtendedClass(set, compilationUnit, classFile, string, map);
            ++n4;
        }
    }

    private void addCompletionsForLocalVarsMethods(CompilationUnit compilationUnit, LocalVariable localVariable, Set<Completion> set) {
        String string;
        ClassFile classFile;
        Type type = localVariable.getType();
        String string2 = compilationUnit.getPackageName();
        if (type.isArray()) {
            ClassFile classFile2 = this.getClassFileFor(compilationUnit, "java.lang.Object");
            this.addCompletionsForExtendedClass(set, compilationUnit, classFile2, string2, null);
            FieldCompletion fieldCompletion = FieldCompletion.createLengthCompletion(this, type);
            set.add(fieldCompletion);
        } else if (!type.isBasicType() && (classFile = this.getClassFileFor(compilationUnit, string = type.getName(true, false))) != null) {
            Map<String, String> map = this.createTypeParamMap(type, classFile);
            this.addCompletionsForExtendedClass(set, compilationUnit, classFile, string2, map);
        }
    }

    private void addShorthandCompletions(Set<Completion> set) {
        if (this.shorthandCache != null) {
            set.addAll(this.shorthandCache.getShorthandCompletions());
        }
    }

    public void setShorthandCache(ShorthandCompletionCache shorthandCompletionCache) {
        this.shorthandCache = shorthandCompletionCache;
    }

    private ClassFile getClassFileFor(CompilationUnit compilationUnit, String string) {
        if (string == null) {
            return null;
        }
        ClassFile classFile = null;
        if (!Util.isFullyQualified(string)) {
            Object object;
            String string2 = compilationUnit.getPackageName();
            if (string2 != null) {
                object = String.valueOf(string2) + "." + string;
                classFile = this.jarManager.getClassEntry((String)object);
            }
            if (classFile == null) {
                object = compilationUnit.getImportIterator();
                while (object.hasNext()) {
                    ImportDeclaration importDeclaration = object.next();
                    String string3 = importDeclaration.getName();
                    if (string3.endsWith(".*")) {
                        String string4 = String.valueOf(string3.substring(0, string3.length() - 1)) + string;
                        classFile = this.jarManager.getClassEntry(string4);
                        if (classFile == null) continue;
                        break;
                    }
                    if (!string3.endsWith("." + string)) continue;
                    classFile = this.jarManager.getClassEntry(string3);
                    break;
                }
            }
            if (classFile == null) {
                object = "java.lang." + string;
                classFile = this.jarManager.getClassEntry((String)object);
            }
        } else {
            classFile = this.jarManager.getClassEntry(string);
        }
        return classFile;
    }

    private void addLocalVarCompletions(Set<Completion> set, Method method, int n) {
        int n2 = 0;
        while (n2 < method.getParameterCount()) {
            FormalParameter formalParameter = method.getParameter(n2);
            set.add(new LocalVariableCompletion((CompletionProvider)this, formalParameter));
            ++n2;
        }
        CodeBlock codeBlock = method.getBody();
        if (codeBlock != null) {
            this.addLocalVarCompletions(set, codeBlock, n);
        }
    }

    private void addLocalVarCompletions(Set<Completion> set, CodeBlock codeBlock, int n) {
        AbstractASTNode abstractASTNode;
        int n2 = 0;
        while (n2 < codeBlock.getLocalVarCount()) {
            abstractASTNode = codeBlock.getLocalVar(n2);
            if (((LocalVariable)abstractASTNode).getNameEndOffset() > n) break;
            set.add(new LocalVariableCompletion((CompletionProvider)this, (LocalVariable)abstractASTNode));
            ++n2;
        }
        n2 = 0;
        while (n2 < codeBlock.getChildBlockCount()) {
            abstractASTNode = codeBlock.getChildBlock(n2);
            if (((CodeBlock)abstractASTNode).containsOffset(n)) {
                this.addLocalVarCompletions(set, (CodeBlock)abstractASTNode, n);
                break;
            }
            if (((CodeBlock)abstractASTNode).getNameStartOffset() > n) break;
            ++n2;
        }
    }

    public void addJar(LibraryInfo libraryInfo) throws IOException {
        this.jarManager.addClassFileSource(libraryInfo);
    }

    private boolean checkStringLiteralMember(JTextComponent jTextComponent, String string, CompilationUnit compilationUnit, Set<Completion> set) {
        boolean bl = false;
        int n = jTextComponent.getCaretPosition() - string.length() - 1;
        if (n > 1) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            try {
                if (rSyntaxDocument.charAt(n) == '\"' && rSyntaxDocument.charAt(n + 1) == '.') {
                    int n2 = rSyntaxTextArea.getLineOfOffset(n);
                    Token token = rSyntaxTextArea.getTokenListForLine(n2);
                    Token token2 = RSyntaxUtilities.getTokenAtOffset(token, n);
                    if (token2 != null && token2.getType() == 13) {
                        ClassFile classFile = this.getClassFileFor(compilationUnit, "java.lang.String");
                        this.addCompletionsForExtendedClass(set, compilationUnit, classFile, compilationUnit.getPackageName(), null);
                        bl = true;
                    } else {
                        System.out.println(token2);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return bl;
    }

    public void clearJars() {
        this.jarManager.clearClassFileSources();
        this.clear();
    }

    private Map<String, String> createTypeParamMap(Type type, ClassFile classFile) {
        HashMap<String, String> hashMap = null;
        List<TypeArgument> list = type.getTypeArguments(type.getIdentifierCount() - 1);
        if (list != null) {
            hashMap = new HashMap<String, String>();
            List<String> list2 = classFile.getParamTypes();
            int n = Math.min(list2 == null ? 0 : list2.size(), list.size());
            int n2 = 0;
            while (n2 < n) {
                TypeArgument typeArgument = list.get(n2);
                hashMap.put(list2.get(n2), typeArgument.toString());
                ++n2;
            }
        }
        return hashMap;
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent jTextComponent, Point point) {
        this.getCompletionsImpl(jTextComponent);
        return super.getCompletionsAt(jTextComponent, point);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent var1_1) {
        var1_1.setCursor(Cursor.getPredefinedCursor(3));
        try {
            block8: {
                this.completions = new ArrayList<E>();
                var2_2 = this.javaProvider.getCompilationUnit();
                if (var2_2 == null) {
                    var9_3 = this.completions;
                    return var9_3;
                }
                var3_5 = new TreeSet<Completion>();
                var4_6 = this.getAlreadyEnteredText(var1_1);
                var5_7 = this.checkStringLiteralMember(var1_1, var4_6, var2_2, var3_5);
                if (!var5_7) {
                    if (var4_6.indexOf(46) == -1) {
                        this.addShorthandCompletions(var3_5);
                    }
                    this.loadImportCompletions(var3_5, var4_6, var2_2);
                    this.jarManager.addCompletions(this, var4_6, var3_5);
                    this.loadCompletionsForCaretPosition(var2_2, var1_1, var4_6, var3_5);
                }
                this.completions = new ArrayList<Completion>(var3_5);
                Collections.sort(this.completions);
                var4_6 = var4_6.substring(var4_6.lastIndexOf(46) + 1);
                var6_8 = Collections.binarySearch(this.completions, var4_6, this.comparator);
                if (var6_8 >= 0) ** GOTO lbl25
                var6_8 = -(var6_8 + 1);
                break block8;
lbl-1000:
                // 1 sources

                {
                    --var6_8;
lbl25:
                    // 2 sources

                    ** while (var6_8 > 0 && this.comparator.compare(this.completions.get((int)(var6_8 - 1)), (Object)var4_6) == 0)
                }
            }
            var7_9 = Collections.binarySearch(this.completions, String.valueOf(var4_6) + '{', this.comparator);
            var7_9 = -(var7_9 + 1);
            var9_4 = this.completions.subList(var6_8, var7_9);
            return var9_4;
        }
        finally {
            var1_1.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public List<LibraryInfo> getJars() {
        return this.jarManager.getClassFileSources();
    }

    public SourceLocation getSourceLocForClass(String string) {
        return this.jarManager.getSourceLocForClass(string);
    }

    private boolean isAccessible(MemberInfo memberInfo, String string) {
        boolean bl = false;
        int n = memberInfo.getAccessFlags();
        if (org.fife.rsta.ac.java.classreader.Util.isPublic(n) || org.fife.rsta.ac.java.classreader.Util.isProtected(n)) {
            bl = true;
        } else if (org.fife.rsta.ac.java.classreader.Util.isDefault(n)) {
            String string2 = memberInfo.getClassFile().getPackageName();
            bl = string == null && string2 == null || string != null && string.equals(string2);
        }
        return bl;
    }

    @Override
    protected boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    private void loadCompletionsForCaretPosition(CompilationUnit compilationUnit, JTextComponent jTextComponent, String string, Set<Completion> set) {
        int n = jTextComponent.getCaretPosition();
        int n2 = string.lastIndexOf(46);
        boolean bl = n2 > -1;
        String string2 = bl ? string.substring(0, n2) : null;
        Iterator<TypeDeclaration> iterator = compilationUnit.getTypeDeclarationIterator();
        while (iterator.hasNext()) {
            TypeDeclaration typeDeclaration = iterator.next();
            int n3 = typeDeclaration.getBodyStartOffset();
            int n4 = typeDeclaration.getBodyEndOffset();
            if (n > n3 && n <= n4) {
                this.loadCompletionsForCaretPosition(compilationUnit, jTextComponent, string, set, typeDeclaration, string2, n);
                continue;
            }
            if (n < n3) break;
        }
    }

    private void loadCompletionsForCaretPosition(CompilationUnit compilationUnit, JTextComponent jTextComponent, String string, Set<Completion> set, TypeDeclaration typeDeclaration, String string2, int n) {
        ClassFile classFile;
        String string3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n2 = 0;
        while (n2 < typeDeclaration.getChildTypeCount()) {
            object5 = typeDeclaration.getChildType(n2);
            this.loadCompletionsForCaretPosition(compilationUnit, jTextComponent, string, set, (TypeDeclaration)object5, string2, n);
            ++n2;
        }
        Object object6 = null;
        object5 = new HashMap();
        if (typeDeclaration instanceof NormalClassDeclaration && (object4 = ((NormalClassDeclaration)(object3 = (NormalClassDeclaration)typeDeclaration)).getTypeParameters()) != null) {
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (TypeParameter)object2.next();
                string3 = ((TypeParameter)object).getName();
                object5.put(string3, string3);
            }
        }
        object3 = compilationUnit.getPackageName();
        object4 = typeDeclaration.getMemberIterator();
        while (object4.hasNext()) {
            object = (Member)object4.next();
            if (object instanceof Method) {
                object2 = (Method)object;
                if (string2 == null || THIS.equals(string2)) {
                    set.add(new MethodCompletion((CompletionProvider)this, (Method)object2));
                }
                if (n < ((Method)object2).getBodyStartOffset() || n >= ((Method)object2).getBodyEndOffset()) continue;
                object6 = object2;
                if (string2 != null) continue;
                this.addLocalVarCompletions(set, (Method)object2, n);
                continue;
            }
            if (!(object instanceof Field) || string2 != null && !THIS.equals(string2)) continue;
            object2 = (Field)object;
            set.add(new FieldCompletion((CompletionProvider)this, (Field)object2));
        }
        if ((string2 == null || THIS.equals(string2)) && typeDeclaration instanceof NormalClassDeclaration && (object2 = ((NormalClassDeclaration)(object = (NormalClassDeclaration)typeDeclaration)).getExtendedType()) != null && (classFile = this.getClassFileFor(compilationUnit, string3 = ((Type)object2).toString())) != null) {
            this.addCompletionsForExtendedClass(set, compilationUnit, classFile, (String)object3, null);
        }
        if (string2 != null && !THIS.equals(string2)) {
            this.loadCompletionsForCaretPositionQualified(compilationUnit, string, set, typeDeclaration, (Method)object6, string2, n);
        }
    }

    private void loadCompletionsForCaretPositionQualified(CompilationUnit compilationUnit, String string, Set<Completion> set, TypeDeclaration typeDeclaration, Method method, String string2, int n) {
        Object object;
        AbstractASTNode abstractASTNode;
        Object object2;
        int n2 = string2.indexOf(46);
        if (n2 > -1) {
            System.out.println("[DEBUG]: Qualified non-this completions currently only go 1 level deep");
            return;
        }
        if (!string2.matches("[A-Za-z_][A-Za-z0-9_\\$]*")) {
            System.out.println("[DEBUG]: Only identifier non-this completions are currently supported");
            return;
        }
        String string3 = compilationUnit.getPackageName();
        boolean bl = false;
        Object object3 = typeDeclaration.getMemberIterator();
        while (object3.hasNext()) {
            Object object4;
            Object object5;
            object2 = object3.next();
            if (!(object2 instanceof Field) || !((Field)(abstractASTNode = (Field)object2)).getName().equals(string2)) continue;
            object = ((Field)abstractASTNode).getType();
            if (((Type)object).isArray()) {
                object5 = this.getClassFileFor(compilationUnit, "java.lang.Object");
                this.addCompletionsForExtendedClass(set, compilationUnit, (ClassFile)object5, string3, null);
                object4 = FieldCompletion.createLengthCompletion(this, (Type)object);
                set.add((Completion)object4);
            } else if (!((Type)object).isBasicType() && (object4 = this.getClassFileFor(compilationUnit, (String)(object5 = ((Type)object).getName(true, false)))) != null) {
                Map<String, String> map = this.createTypeParamMap((Type)object, (ClassFile)object4);
                this.addCompletionsForExtendedClass(set, compilationUnit, (ClassFile)object4, string3, map);
                int n3 = 0;
                while (n3 < ((ClassFile)object4).getImplementedInterfaceCount()) {
                    String string4 = ((ClassFile)object4).getImplementedInterfaceName(n3, true);
                    object4 = this.getClassFileFor(compilationUnit, string4);
                    System.out.println(object4);
                    ++n3;
                }
            }
            bl = true;
            break;
        }
        if (method != null) {
            CodeBlock codeBlock;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < method.getParameterCount()) {
                abstractASTNode = method.getParameter(n4);
                object = ((FormalParameter)abstractASTNode).getName();
                if (string2.equals(object)) {
                    this.addCompletionsForLocalVarsMethods(compilationUnit, (LocalVariable)abstractASTNode, set);
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2 && (codeBlock = method.getBody()) != null) {
                this.loadCompletionsForCaretPositionQualifiedCodeBlock(compilationUnit, set, typeDeclaration, codeBlock, string2, n);
            }
            bl |= bl2;
        }
        if (!bl && (object2 = this.jarManager.getClassesWithUnqualifiedName(string2, (List<ImportDeclaration>)(object3 = compilationUnit.getImports()))) != null) {
            int n5 = 0;
            while (n5 < object2.size()) {
                object = (ClassFile)object2.get(n5);
                this.addCompletionsForStaticMembers(set, compilationUnit, (ClassFile)object, string3);
                ++n5;
            }
        }
    }

    private void loadCompletionsForCaretPositionQualifiedCodeBlock(CompilationUnit compilationUnit, Set<Completion> set, TypeDeclaration typeDeclaration, CodeBlock codeBlock, String string, int n) {
        AbstractASTNode abstractASTNode;
        boolean bl = false;
        int n2 = 0;
        while (n2 < codeBlock.getLocalVarCount()) {
            abstractASTNode = codeBlock.getLocalVar(n2);
            if (((LocalVariable)abstractASTNode).getNameEndOffset() > n) break;
            if (string.equals(((LocalVariable)abstractASTNode).getName())) {
                this.addCompletionsForLocalVarsMethods(compilationUnit, (LocalVariable)abstractASTNode, set);
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            return;
        }
        n2 = 0;
        while (n2 < codeBlock.getChildBlockCount()) {
            abstractASTNode = codeBlock.getChildBlock(n2);
            if (((CodeBlock)abstractASTNode).containsOffset(n)) {
                this.loadCompletionsForCaretPositionQualifiedCodeBlock(compilationUnit, set, typeDeclaration, (CodeBlock)abstractASTNode, string, n);
                break;
            }
            if (((CodeBlock)abstractASTNode).getNameStartOffset() > n) break;
            ++n2;
        }
    }

    private void loadCompletionsForImport(Set<Completion> set, String string, String string2) {
        if (string.endsWith(".*")) {
            String string3 = string.substring(0, string.length() - 2);
            boolean bl = string3.equals(string2);
            List<ClassFile> list = this.jarManager.getClassesInPackage(string3, bl);
            for (ClassFile classFile : list) {
                set.add(new ClassCompletion((CompletionProvider)this, classFile));
            }
        } else {
            ClassFile classFile = this.jarManager.getClassEntry(string);
            if (classFile != null) {
                set.add(new ClassCompletion((CompletionProvider)this, classFile));
            }
        }
    }

    private void loadImportCompletions(Set<Completion> set, String string, CompilationUnit compilationUnit) {
        if (string.indexOf(46) > -1) {
            return;
        }
        String string2 = compilationUnit.getPackageName();
        this.loadCompletionsForImport(set, JAVA_LANG_PACKAGE, string2);
        Iterator<ImportDeclaration> iterator = compilationUnit.getImportIterator();
        while (iterator.hasNext()) {
            ImportDeclaration importDeclaration = iterator.next();
            String string3 = importDeclaration.getName();
            if (JAVA_LANG_PACKAGE.equals(string3)) continue;
            this.loadCompletionsForImport(set, string3, string2);
        }
    }

    public boolean removeJar(File file) {
        boolean bl = this.jarManager.removeClassFileSource(file);
        if (bl) {
            this.clear();
        }
        return bl;
    }

    void setJavaProvider(JavaCompletionProvider javaCompletionProvider) {
        this.javaProvider = javaCompletionProvider;
    }
}

