/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;

class MethodInfoData
implements MemberCompletion.Data {
    private SourceCompletionProvider provider;
    private MethodInfo info;
    private List<String> paramNames;

    public MethodInfoData(MethodInfo methodInfo, SourceCompletionProvider sourceCompletionProvider) {
        this.info = methodInfo;
        this.provider = sourceCompletionProvider;
    }

    @Override
    public String getEnclosingClassName(boolean bl) {
        return this.info.getClassFile().getClassName(bl);
    }

    @Override
    public String getIcon() {
        String string = null;
        int n = this.info.getAccessFlags();
        string = org.fife.rsta.ac.java.classreader.Util.isDefault(n) ? "methodDefaultIcon" : (org.fife.rsta.ac.java.classreader.Util.isPrivate(n) ? "methodPrivateIcon" : (org.fife.rsta.ac.java.classreader.Util.isProtected(n) ? "methodProtectedIcon" : (org.fife.rsta.ac.java.classreader.Util.isPublic(n) ? "methodPublicIcon" : "methodDefaultIcon")));
        return string;
    }

    private Method getMethodFromSourceLoc(SourceLocation sourceLocation, ClassFile classFile) {
        Method method = null;
        CompilationUnit compilationUnit = Util.getCompilationUnitFromDisk(sourceLocation, classFile);
        if (compilationUnit != null) {
            Iterator<TypeDeclaration> iterator = compilationUnit.getTypeDeclarationIterator();
            block0: while (iterator.hasNext()) {
                TypeDeclaration typeDeclaration = iterator.next();
                String string = typeDeclaration.getName();
                if (!string.equals(classFile.getClassName(false))) continue;
                ArrayList<Method> arrayList = null;
                int n = 0;
                while (n < typeDeclaration.getMemberCount()) {
                    Method method2;
                    Member member = typeDeclaration.getMember(n);
                    if (member instanceof Method && member.getName().equals(this.info.getName()) && (method2 = (Method)member).getParameterCount() == this.info.getParameterCount()) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Method>(1);
                        }
                        arrayList.add(method2);
                    }
                    ++n;
                }
                if (arrayList == null) break;
                if (arrayList.size() == 1) {
                    method = (Method)arrayList.get(0);
                    break;
                }
                for (Method method3 : arrayList) {
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < this.info.getParameterCount()) {
                        FormalParameter formalParameter;
                        String string2;
                        String string3 = this.info.getParameterType(n2, false);
                        if (!string3.equals(string2 = (formalParameter = method3.getParameter(n2)).getType().toString())) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) continue;
                    method = method3;
                    break block0;
                }
            }
        }
        return method;
    }

    public String getParameterName(int n) {
        String string = this.info.getParameterName(n);
        if (string == null) {
            if (this.paramNames == null) {
                this.paramNames = new ArrayList<String>(1);
                int n2 = 0;
                String string2 = this.getSummary();
                if (string2 != null && string2.startsWith("/**")) {
                    int n3 = 0;
                    int n4 = string2.length();
                    while ((n3 = string2.indexOf("@param", n2)) > -1) {
                        int n5 = n3 + "@param".length() + 1;
                        while (n5 < n4 && Character.isWhitespace(string2.charAt(n5))) {
                            ++n5;
                        }
                        if (n5 >= n4) break;
                        int n6 = n5;
                        int n7 = n6 + 1;
                        while (n7 < n4 && Character.isJavaIdentifierPart(string2.charAt(n7))) {
                            ++n7;
                        }
                        this.paramNames.add(string2.substring(n6, n7));
                        n2 = n7;
                    }
                }
            }
            if (n < this.paramNames.size()) {
                string = this.paramNames.get(n);
            }
        }
        if (string == null) {
            string = "arg" + n;
        }
        return string;
    }

    @Override
    public String getSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.info.getName());
        stringBuilder.append('(');
        int n = this.info.getParameterCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(this.info.getParameterType(n2, false));
            stringBuilder.append(' ');
            stringBuilder.append(this.getParameterName(n2));
            if (n2 < n - 1) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getSummary() {
        ClassFile classFile = this.info.getClassFile();
        SourceLocation sourceLocation = this.provider.getSourceLocForClass(classFile.getClassName(true));
        String string = null;
        if (sourceLocation != null) {
            string = this.getSummaryFromSourceLoc(sourceLocation, classFile);
        }
        if (string == null) {
            string = this.info.getSignature();
        }
        return string;
    }

    private String getSummaryFromSourceLoc(SourceLocation sourceLocation, ClassFile classFile) {
        Method method = this.getMethodFromSourceLoc(sourceLocation, classFile);
        return method != null ? method.getDocComment() : null;
    }

    @Override
    public String getType() {
        return this.info.getReturnTypeString(false);
    }

    @Override
    public boolean isAbstract() {
        return this.info.isAbstract();
    }

    @Override
    public boolean isConstructor() {
        return this.info.isConstructor();
    }

    @Override
    public boolean isDeprecated() {
        return this.info.isDeprecated();
    }

    @Override
    public boolean isFinal() {
        return this.info.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.info.isStatic();
    }
}

