/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.MethodData;
import org.fife.rsta.ac.java.MethodInfoData;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;

class MethodCompletion
extends FunctionCompletion
implements MemberCompletion {
    private MemberCompletion.Data data;
    private String compareString;
    private static final int NON_CONSTRUCTOR_RELEVANCE = 2;

    public MethodCompletion(CompletionProvider completionProvider, Method method) {
        super(completionProvider, method.getName(), method.getType() == null ? "void" : method.getType().toString());
        this.setDefinedIn(method.getParentTypeDeclaration().getName());
        this.data = new MethodData(method);
        this.setRelevanceAppropriately();
        int n = method.getParameterCount();
        ArrayList<ParameterizedCompletion.Parameter> arrayList = new ArrayList<ParameterizedCompletion.Parameter>(n);
        int n2 = 0;
        while (n2 < n) {
            FormalParameter formalParameter = method.getParameter(n2);
            Type type = formalParameter.getType();
            String string = formalParameter.getName();
            arrayList.add(new ParameterizedCompletion.Parameter(type, string));
            ++n2;
        }
        this.setParams(arrayList);
    }

    public MethodCompletion(CompletionProvider completionProvider, MethodInfo methodInfo) {
        super(completionProvider, methodInfo.getName(), methodInfo.getReturnTypeString(false));
        this.setDefinedIn(methodInfo.getClassFile().getClassName(false));
        this.data = new MethodInfoData(methodInfo, (SourceCompletionProvider)completionProvider);
        this.setRelevanceAppropriately();
        String[] stringArray = methodInfo.getParameterTypes();
        ArrayList<ParameterizedCompletion.Parameter> arrayList = new ArrayList<ParameterizedCompletion.Parameter>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = ((MethodInfoData)this.data).getParameterName(n);
            String string2 = stringArray[n].substring(stringArray[n].lastIndexOf(46) + 1);
            arrayList.add(new ParameterizedCompletion.Parameter(string2, string));
            ++n;
        }
        this.setParams(arrayList);
    }

    @Override
    public int compareTo(Completion completion) {
        int n = -1;
        if (completion == this) {
            n = 0;
        } else if (completion instanceof MethodCompletion) {
            n = this.getCompareString().compareTo(((MethodCompletion)completion).getCompareString());
        } else if (completion != null && (n = this.toString().compareToIgnoreCase(completion.toString())) == 0) {
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46));
            String string2 = completion.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46));
            n = string.compareTo(string2);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof MethodCompletion && ((MethodCompletion)object).getCompareString().equals(this.getCompareString());
    }

    @Override
    public String getAlreadyEntered(JTextComponent jTextComponent) {
        String string = this.getProvider().getAlreadyEnteredText(jTextComponent);
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getCompareString() {
        if (this.compareString == null) {
            StringBuilder stringBuilder = new StringBuilder(this.getName());
            int n = this.getParamCount();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            int n2 = 0;
            while (n2 < n) {
                String string = this.getParam(n2).getType();
                stringBuilder.append(string);
                if (n2 < n - 1) {
                    stringBuilder.append(',');
                }
                ++n2;
            }
            this.compareString = stringBuilder.toString();
        }
        return this.compareString;
    }

    @Override
    public String getEnclosingClassName(boolean bl) {
        return this.data.getEnclosingClassName(bl);
    }

    @Override
    public Icon getIcon() {
        return IconFactory.get().getIcon(this.data);
    }

    @Override
    public String getSignature() {
        return this.data.getSignature();
    }

    @Override
    public String getSummary() {
        String string = this.data.getSummary();
        if (string != null && string.startsWith("/**")) {
            string = Util.docCommentToHtml(string);
        }
        return string;
    }

    public int hashCode() {
        return this.getCompareString().hashCode();
    }

    @Override
    public boolean isDeprecated() {
        return this.data.isDeprecated();
    }

    @Override
    public void rendererText(Graphics graphics, int n, int n2, boolean bl) {
        MethodCompletion.rendererText(this, graphics, n, n2, bl);
    }

    private void setRelevanceAppropriately() {
        if (!this.data.isConstructor()) {
            this.setRelevance(2);
        }
    }

    public static void rendererText(MemberCompletion memberCompletion, Graphics graphics, int n, int n2, boolean bl) {
        String string = memberCompletion.getType();
        int n3 = string.lastIndexOf(46);
        if (n3 > -1) {
            string = string.substring(n3 + 1);
        }
        String string2 = memberCompletion.getSignature();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string2, n, n2);
        int n4 = n + fontMetrics.stringWidth(string2);
        if (memberCompletion.isDeprecated()) {
            int n5 = n2 + fontMetrics.getDescent() - fontMetrics.getHeight() / 2;
            graphics.drawLine(n, n5, n4, n5);
        }
        n = n4;
        StringBuilder stringBuilder = new StringBuilder(" : ").append(string);
        stringBuilder.append(" - ");
        String string3 = stringBuilder.toString();
        graphics.drawString(string3, n, n2);
        n += fontMetrics.stringWidth(string3);
        Color color = graphics.getColor();
        if (!bl) {
            graphics.setColor(Color.GRAY);
        }
        graphics.drawString(memberCompletion.getEnclosingClassName(false), n, n2);
        if (!bl) {
            graphics.setColor(color);
        }
    }

    @Override
    public String toString() {
        return this.getSignature();
    }
}

