/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Graphics;
import javax.swing.Icon;
import org.fife.rsta.ac.java.AbstractJavaSourceCompletion;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.ui.autocomplete.CompletionProvider;

class LocalVariableCompletion
extends AbstractJavaSourceCompletion {
    private LocalVariable localVar;
    private static final int RELEVANCE = 4;

    public LocalVariableCompletion(CompletionProvider completionProvider, LocalVariable localVariable) {
        super(completionProvider, localVariable.getName());
        this.localVar = localVariable;
        this.setRelevance(4);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof LocalVariableCompletion && ((LocalVariableCompletion)object).getReplacementText().equals(this.getReplacementText());
    }

    @Override
    public Icon getIcon() {
        return IconFactory.get().getIcon("localVariableIcon");
    }

    @Override
    public String getToolTipText() {
        return this.localVar.getType() + " " + this.localVar.getName();
    }

    public int hashCode() {
        return this.getReplacementText().hashCode();
    }

    @Override
    public void rendererText(Graphics graphics, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.localVar.getName());
        stringBuilder.append(" : ");
        stringBuilder.append(this.localVar.getType());
        graphics.drawString(stringBuilder.toString(), n, n2);
    }
}

