/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.FieldCompletion;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DescWindowCallback;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.Util;

public class JavadocUrlHandler
implements ExternalURLHandler {
    private String doBackups(String string, int n) {
        int n2 = string.length();
        while (n2 > -1 && n > 0) {
            n2 = string.lastIndexOf(46, n2);
            --n;
        }
        return n2 > -1 ? string.substring(0, n2) : "";
    }

    private JavaLanguageSupport getJavaLanguageSupport() {
        return (JavaLanguageSupport)LanguageSupportFactory.get().getSupportFor("text/java");
    }

    private static final String getAnchor(String string) {
        int n = string.indexOf(35);
        return n > -1 ? string.substring(n + 1) : null;
    }

    private static final String[] getArgs(String string) {
        int n;
        String[] stringArray = null;
        int n2 = string.indexOf(40);
        if (n2 > -1 && (n = string.indexOf(41, n2)) > -1 && n > n2 + 1) {
            String string2 = string.substring(n2, n);
            stringArray = string2.split("\\s*,\\s*");
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String getClass(Completion completion, String string) {
        String string2 = null;
        if (completion instanceof ClassCompletion) {
            string2 = ((ClassCompletion)completion).getClassName(true);
        } else if (completion instanceof MemberCompletion) {
            MemberCompletion memberCompletion = (MemberCompletion)completion;
            string2 = memberCompletion.getEnclosingClassName(true);
        } else {
            System.err.println("Can't determine class from completion type: " + completion.getClass() + " (" + completion.toString() + ") - href: " + string);
        }
        return string2;
    }

    private String getPackage(Completion completion, String string) {
        String string2 = null;
        if (completion instanceof ClassCompletion) {
            string2 = ((ClassCompletion)completion).getPackageName();
        } else if (completion instanceof MemberCompletion) {
            int n;
            String string3 = ((MemberCompletion)completion).getEnclosingClassName(true);
            if (string3 != null && (n = string3.lastIndexOf(46)) > -1) {
                string2 = string3.substring(0, n);
            }
        } else {
            System.err.println("Can't determine package from completion type: " + completion.getClass() + " (" + completion.toString() + ") - href: " + string);
        }
        return string2;
    }

    private boolean isRelativeUrl(String string) {
        String[] stringArray = new String[]{".html", ".htm"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n]) || string.indexOf(String.valueOf(stringArray[n]) + "#") > -1 || string.indexOf(String.valueOf(stringArray[n]) + "?") > -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void urlClicked(HyperlinkEvent hyperlinkEvent, Completion completion, DescWindowCallback descWindowCallback) {
        URL uRL = hyperlinkEvent.getURL();
        if (uRL != null) {
            try {
                Util.browse(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                uRISyntaxException.printStackTrace();
            }
            return;
        }
        String string = hyperlinkEvent.getDescription();
        if (string != null) {
            if (this.isRelativeUrl(string)) {
                int n = string.indexOf(".htm");
                if (n > -1) {
                    String string2 = JavadocUrlHandler.getAnchor(string);
                    String string3 = string.substring(0, n);
                    int n2 = 0;
                    while (string3.startsWith("../")) {
                        ++n2;
                        string3 = string3.substring(3);
                    }
                    string3 = string3.replace('/', '.');
                    String string4 = this.getPackage(completion, string);
                    if (string4 != null) {
                        string3 = String.valueOf(this.doBackups(string4, n2)) + "." + string3;
                        JavaLanguageSupport javaLanguageSupport = this.getJavaLanguageSupport();
                        ClassFile classFile = javaLanguageSupport.getJarManager().getClassEntry(string3);
                        if (classFile != null) {
                            ClassCompletion classCompletion = new ClassCompletion(completion.getProvider(), classFile);
                            descWindowCallback.showSummaryFor(classCompletion, string2);
                        }
                    }
                }
            } else {
                JavaLanguageSupport javaLanguageSupport = this.getJavaLanguageSupport();
                String string5 = string;
                String string6 = null;
                int n = string.indexOf(35);
                if (n > -1) {
                    string6 = string5.substring(n + 1);
                    string5 = string5.substring(0, n);
                }
                if (string6 == null) {
                    Object object;
                    boolean bl = false;
                    if (string5.indexOf(46) == -1) {
                        object = this.getPackage(completion, string);
                        if (object != null) {
                            string5 = String.valueOf(object) + "." + string5;
                        }
                        bl = true;
                    }
                    if ((object = javaLanguageSupport.getJarManager().getClassEntry(string5)) == null && bl) {
                        int n3 = string5.lastIndexOf(46);
                        string5 = "java.lang." + string5.substring(n3 + 1);
                        object = javaLanguageSupport.getJarManager().getClassEntry(string5);
                    }
                    if (object != null) {
                        ClassCompletion classCompletion = new ClassCompletion(completion.getProvider(), (ClassFile)object);
                        descWindowCallback.showSummaryFor(classCompletion, null);
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        System.err.println("Unknown class: " + string5);
                    }
                } else {
                    Object object;
                    boolean bl = false;
                    if (n == 0) {
                        string5 = this.getClass(completion, string);
                    } else if (string5.indexOf(46) == -1) {
                        object = this.getPackage(completion, string);
                        if (object != null) {
                            string5 = String.valueOf(object) + "." + string5;
                        }
                        bl = true;
                    }
                    object = javaLanguageSupport.getJarManager().getClassEntry(string5);
                    if (object == null && bl) {
                        int n4 = string5.lastIndexOf(46);
                        string5 = "java.lang." + string5.substring(n4 + 1);
                        object = javaLanguageSupport.getJarManager().getClassEntry(string5);
                    }
                    if (object != null) {
                        BasicCompletion basicCompletion = null;
                        int n5 = string6.indexOf(40);
                        if (n5 == -1) {
                            FieldInfo fieldInfo = ((ClassFile)object).getFieldInfoByName(string6);
                            if (fieldInfo != null) {
                                basicCompletion = new FieldCompletion(completion.getProvider(), fieldInfo);
                            } else {
                                List<MethodInfo> list = ((ClassFile)object).getMethodInfoByName(string6, -1);
                                if (list != null && list.size() > 0) {
                                    MethodInfo methodInfo = list.get(0);
                                    basicCompletion = new MethodCompletion(completion.getProvider(), methodInfo);
                                }
                            }
                        } else {
                            String[] stringArray = JavadocUrlHandler.getArgs(string6);
                            String string7 = string6.substring(0, n5);
                            List<MethodInfo> list = ((ClassFile)object).getMethodInfoByName(string7, stringArray.length);
                            if (list != null && list.size() > 0) {
                                if (list.size() > 1) {
                                    System.err.println("Multiple overload support not yet implemented");
                                } else {
                                    MethodInfo methodInfo = list.get(0);
                                    basicCompletion = new MethodCompletion(completion.getProvider(), methodInfo);
                                }
                            }
                        }
                        if (basicCompletion != null) {
                            descWindowCallback.showSummaryFor(basicCompletion, null);
                        }
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        System.err.println("Unknown class: " + string5 + " (href: " + string + ")");
                    }
                }
            }
        }
    }
}

