/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.rjc.ast.CodeBlock;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.LocalVariable;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.SelectRegionLinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

class JavaLinkGenerator
implements LinkGenerator {
    private JavaLanguageSupport jls;

    JavaLinkGenerator(JavaLanguageSupport javaLanguageSupport) {
        this.jls = javaLanguageSupport;
    }

    private IsLinkableCheckResult checkForLinkableToken(RSyntaxTextArea rSyntaxTextArea, int n) {
        IsLinkableCheckResult isLinkableCheckResult = null;
        if (n >= 0) {
            try {
                int n2 = rSyntaxTextArea.getLineOfOffset(n);
                Token token = rSyntaxTextArea.getTokenListForLine(n2);
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                Token token2 = null;
                Token token3 = token;
                while (token3 != null && token3.isPaintable()) {
                    if (token3.containsPosition(n)) {
                        TokenImpl tokenImpl = new TokenImpl(token3);
                        boolean bl = false;
                        if (token2 == null) {
                            token2 = RSyntaxUtilities.getPreviousImportantToken(rSyntaxDocument, n2 - 1);
                        }
                        if (token2 == null || !token2.isSingleChar('.')) {
                            Token token4 = RSyntaxUtilities.getNextImportantToken(token3.getNextToken(), rSyntaxTextArea, n2);
                            if (token4 != null && token4.isSingleChar(22, '(')) {
                                bl = true;
                            }
                            isLinkableCheckResult = new IsLinkableCheckResult(tokenImpl, bl);
                        }
                        break;
                    }
                    if (!token3.isCommentOrWhitespace()) {
                        token2 = token3;
                    }
                    token3 = token3.getNextToken();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return isLinkableCheckResult;
    }

    @Override
    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea rSyntaxTextArea, int n) {
        int n2 = -1;
        int n3 = -1;
        IsLinkableCheckResult isLinkableCheckResult = this.checkForLinkableToken(rSyntaxTextArea, n);
        if (isLinkableCheckResult != null) {
            JavaParser javaParser = this.jls.getParser(rSyntaxTextArea);
            CompilationUnit compilationUnit = javaParser.getCompilationUnit();
            Token token = isLinkableCheckResult.token;
            boolean bl = isLinkableCheckResult.method;
            if (compilationUnit != null) {
                TypeDeclaration typeDeclaration = compilationUnit.getDeepestTypeDeclarationAtOffset(n);
                boolean bl2 = false;
                boolean bl3 = true;
                boolean bl4 = false;
                while (typeDeclaration != null && n2 == -1) {
                    Member member;
                    Object object;
                    Object object2;
                    if (!bl && bl3) {
                        object2 = typeDeclaration.getMemberIterator();
                        while (object2.hasNext()) {
                            object = null;
                            member = (Member)object2.next();
                            CodeBlock codeBlock = null;
                            if (member instanceof Method) {
                                object = (Method)member;
                                if (((Method)object).getBodyContainsOffset(n) && ((Method)object).getBody() != null) {
                                    bl4 = ((Method)object).isStatic();
                                    codeBlock = ((Method)object).getBody().getDeepestCodeBlockContaining(n);
                                }
                            } else if (member instanceof CodeBlock) {
                                codeBlock = (CodeBlock)member;
                                bl4 = codeBlock.isStatic();
                                codeBlock = codeBlock.getDeepestCodeBlockContaining(n);
                            }
                            if (codeBlock == null) continue;
                            String string = token.getLexeme();
                            List<LocalVariable> list = codeBlock.getLocalVarsBefore(n);
                            Collections.reverse(list);
                            for (LocalVariable localVariable : list) {
                                if (!string.equals(localVariable.getName())) continue;
                                n2 = localVariable.getNameStartOffset();
                                n3 = localVariable.getNameEndOffset();
                            }
                            if (n2 != -1 || object == null) break;
                            int n4 = 0;
                            while (n4 < ((Method)object).getParameterCount()) {
                                FormalParameter formalParameter = ((Method)object).getParameter(n4);
                                if (string.equals(formalParameter.getName())) {
                                    n2 = formalParameter.getNameStartOffset();
                                    n3 = formalParameter.getNameEndOffset();
                                }
                                ++n4;
                            }
                            break block1;
                        }
                    }
                    if (n2 == -1) {
                        object2 = token.getLexeme();
                        object = bl ? typeDeclaration.getMethodIterator() : typeDeclaration.getFieldIterator();
                        while (object.hasNext()) {
                            member = object.next();
                            if ((bl4 || bl2) && !member.isStatic() || !((String)object2).equals(member.getName())) continue;
                            n2 = member.getNameStartOffset();
                            n3 = member.getNameEndOffset();
                            break;
                        }
                    }
                    if (n2 != -1) continue;
                    bl2 |= typeDeclaration.isStatic();
                    typeDeclaration = typeDeclaration.getParentType();
                    bl3 = false;
                }
            }
            if (n2 > -1) {
                return new SelectRegionLinkGeneratorResult(rSyntaxTextArea, token.getOffset(), n2, n3);
            }
        }
        return null;
    }

    private static class IsLinkableCheckResult {
        private Token token;
        private boolean method;

        private IsLinkableCheckResult(Token token, boolean bl) {
            this.token = token;
            this.method = bl;
        }
    }
}

