/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.GoToMemberAction;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaCellRenderer;
import org.fife.rsta.ac.java.JavaCompletionProvider;
import org.fife.rsta.ac.java.JavaLinkGenerator;
import org.fife.rsta.ac.java.JavaParamListCellRenderer;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.JavadocUrlHandler;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.rsta.ac.java.tree.JavaOutlineTree;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class JavaLanguageSupport
extends AbstractLanguageSupport {
    private Map<JavaParser, Info> parserToInfoMap = new HashMap<JavaParser, Info>();
    private JarManager jarManager = new JarManager();
    private static final String PROPERTY_LISTENER = "org.fife.rsta.ac.java.JavaLanguageSupport.Listener";

    public JavaLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
    }

    public JavaCompletionProvider getCompletionProvider(RSyntaxTextArea rSyntaxTextArea) {
        AutoCompletion autoCompletion = this.getAutoCompletionFor(rSyntaxTextArea);
        return (JavaCompletionProvider)autoCompletion.getCompletionProvider();
    }

    public JarManager getJarManager() {
        return this.jarManager;
    }

    public JavaParser getParser(RSyntaxTextArea rSyntaxTextArea) {
        Object object = rSyntaxTextArea.getClientProperty("org.fife.rsta.ac.LanguageSupport.LanguageParser");
        if (object instanceof JavaParser) {
            return (JavaParser)object;
        }
        return null;
    }

    @Override
    public void install(RSyntaxTextArea rSyntaxTextArea) {
        JavaCompletionProvider javaCompletionProvider = new JavaCompletionProvider(this.jarManager);
        JavaAutoCompletion javaAutoCompletion = new JavaAutoCompletion(javaCompletionProvider, rSyntaxTextArea);
        javaAutoCompletion.setListCellRenderer(new JavaCellRenderer());
        javaAutoCompletion.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        javaAutoCompletion.setAutoActivationEnabled(this.isAutoActivationEnabled());
        javaAutoCompletion.setAutoActivationDelay(this.getAutoActivationDelay());
        javaAutoCompletion.setExternalURLHandler(new JavadocUrlHandler());
        javaAutoCompletion.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        javaAutoCompletion.setParamChoicesRenderer(new JavaParamListCellRenderer());
        javaAutoCompletion.setShowDescWindow(this.getShowDescWindow());
        javaAutoCompletion.install(rSyntaxTextArea);
        this.installImpl(rSyntaxTextArea, javaAutoCompletion);
        rSyntaxTextArea.setToolTipSupplier(javaCompletionProvider);
        Listener listener = new Listener(rSyntaxTextArea);
        rSyntaxTextArea.putClientProperty(PROPERTY_LISTENER, listener);
        JavaParser javaParser = new JavaParser(rSyntaxTextArea);
        rSyntaxTextArea.putClientProperty("org.fife.rsta.ac.LanguageSupport.LanguageParser", javaParser);
        rSyntaxTextArea.addParser(javaParser);
        rSyntaxTextArea.setToolTipSupplier(javaCompletionProvider);
        Info info = new Info(rSyntaxTextArea, javaCompletionProvider, javaParser);
        this.parserToInfoMap.put(javaParser, info);
        this.installKeyboardShortcuts(rSyntaxTextArea);
        rSyntaxTextArea.setLinkGenerator(new JavaLinkGenerator(this));
    }

    private void installKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        int n = rSyntaxTextArea.getToolkit().getMenuShortcutKeyMask();
        int n2 = 1;
        inputMap.put(KeyStroke.getKeyStroke(79, n | n2), "GoToType");
        actionMap.put("GoToType", new GoToMemberAction(JavaOutlineTree.class));
    }

    @Override
    public void uninstall(RSyntaxTextArea rSyntaxTextArea) {
        this.uninstallImpl(rSyntaxTextArea);
        JavaParser javaParser = this.getParser(rSyntaxTextArea);
        Info info = this.parserToInfoMap.remove(javaParser);
        if (info != null) {
            javaParser.removePropertyChangeListener("CompilationUnit", info);
        }
        rSyntaxTextArea.removeParser(javaParser);
        rSyntaxTextArea.putClientProperty("org.fife.rsta.ac.LanguageSupport.LanguageParser", null);
        rSyntaxTextArea.setToolTipSupplier(null);
        Object object = rSyntaxTextArea.getClientProperty(PROPERTY_LISTENER);
        if (object instanceof Listener) {
            ((Listener)object).uninstall();
            rSyntaxTextArea.putClientProperty(PROPERTY_LISTENER, null);
        }
        this.uninstallKeyboardShortcuts(rSyntaxTextArea);
        rSyntaxTextArea.setLinkGenerator(null);
    }

    private void uninstallKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        int n = rSyntaxTextArea.getToolkit().getMenuShortcutKeyMask();
        int n2 = 1;
        inputMap.remove(KeyStroke.getKeyStroke(79, n | n2));
        actionMap.remove("GoToType");
    }

    private static class ImportToAddInfo {
        public int offs;
        public String text;

        public ImportToAddInfo(int n, String string) {
            this.offs = n;
            this.text = string;
        }
    }

    private static class Info
    implements PropertyChangeListener {
        public JavaCompletionProvider provider;

        public Info(RSyntaxTextArea rSyntaxTextArea, JavaCompletionProvider javaCompletionProvider, JavaParser javaParser) {
            this.provider = javaCompletionProvider;
            javaParser.addPropertyChangeListener("CompilationUnit", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("CompilationUnit".equals(string)) {
                CompilationUnit compilationUnit = (CompilationUnit)propertyChangeEvent.getNewValue();
                this.provider.setCompilationUnit(compilationUnit);
            }
        }
    }

    private class JavaAutoCompletion
    extends AutoCompletion {
        private RSyntaxTextArea textArea;
        private String replacementTextPrefix;

        public JavaAutoCompletion(JavaCompletionProvider javaCompletionProvider, RSyntaxTextArea rSyntaxTextArea) {
            super(javaCompletionProvider);
            this.textArea = rSyntaxTextArea;
        }

        private String getCurrentLineText() {
            int n = this.textArea.getCaretPosition();
            Element element = this.textArea.getDocument().getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getEndOffset();
            int n4 = element2.getStartOffset();
            String string = "";
            try {
                string = this.textArea.getText(n4, n3 - n4).trim();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return string;
        }

        @Override
        protected String getReplacementText(Completion completion, Document document, int n, int n2) {
            String string = super.getReplacementText(completion, document, n, n2);
            if (this.replacementTextPrefix != null) {
                string = String.valueOf(this.replacementTextPrefix) + string;
                this.replacementTextPrefix = null;
            }
            return string;
        }

        private ImportToAddInfo getShouldAddImport(ClassCompletion classCompletion) {
            String string = this.getCurrentLineText();
            if (!string.startsWith("import ")) {
                Object object;
                Object object2;
                JavaCompletionProvider javaCompletionProvider = (JavaCompletionProvider)this.getCompletionProvider();
                CompilationUnit compilationUnit = javaCompletionProvider.getCompilationUnit();
                int n = 0;
                boolean bl = false;
                if (compilationUnit == null) {
                    return null;
                }
                if ("java.lang".equals(classCompletion.getPackageName())) {
                    return null;
                }
                String string2 = classCompletion.getClassName(false);
                String string3 = classCompletion.getClassName(true);
                int n2 = string3.lastIndexOf(46);
                boolean bl2 = n2 > -1;
                Package package_ = compilationUnit.getPackage();
                if (bl2 && package_ != null ? ((String)(object2 = string3.substring(0, n2))).equals(object = package_.getName()) : !bl2 && package_ == null) {
                    return null;
                }
                object2 = compilationUnit.getImportIterator();
                while (object2.hasNext()) {
                    int n3;
                    String string4;
                    String string5;
                    object = (ImportDeclaration)object2.next();
                    n = ((ImportDeclaration)object).getNameEndOffset() + 1;
                    if (((ImportDeclaration)object).isStatic()) continue;
                    if (((ImportDeclaration)object).isWildcard()) {
                        String string6;
                        if (n2 <= -1 || !(string5 = (string4 = ((ImportDeclaration)object).getName()).substring(0, n3 = string4.lastIndexOf(46))).equals(string6 = string3.substring(0, n2))) continue;
                        bl = true;
                        break;
                    }
                    string4 = ((ImportDeclaration)object).getName();
                    string5 = string4.substring((n3 = string4.lastIndexOf(46)) + 1);
                    if (!string2.equals(string5)) continue;
                    n = -1;
                    if (!string3.equals(string4)) break;
                    bl = true;
                    break;
                }
                if (!bl) {
                    object = new StringBuilder();
                    if (n == 0 && package_ != null) {
                        n = package_.getNameEndOffset() + 1;
                        ((StringBuilder)object).append('\n');
                    }
                    if (n > -1) {
                        if (n > 0) {
                            ((StringBuilder)object).append("\nimport ").append(string3).append(';');
                        } else {
                            ((StringBuilder)object).append("import ").append(string3).append(";\n");
                        }
                        return new ImportToAddInfo(n, ((StringBuilder)object).toString());
                    }
                    int n4 = string3.lastIndexOf(46);
                    if (n4 > -1) {
                        String string7;
                        this.replacementTextPrefix = string7 = string3.substring(0, n4 + 1);
                    }
                }
            }
            return null;
        }

        @Override
        protected void insertCompletion(Completion completion, boolean bl) {
            ImportToAddInfo importToAddInfo = null;
            if (completion instanceof ClassCompletion && (importToAddInfo = this.getShouldAddImport((ClassCompletion)completion)) != null) {
                this.textArea.beginAtomicEdit();
            }
            try {
                super.insertCompletion(completion, bl);
                if (importToAddInfo != null) {
                    this.textArea.insert(importToAddInfo.text, importToAddInfo.offs);
                }
            }
            finally {
                this.textArea.endAtomicEdit();
            }
        }

        @Override
        protected int refreshPopupWindow() {
            JavaParser javaParser = JavaLanguageSupport.this.getParser(this.textArea);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
            String string = this.textArea.getSyntaxEditingStyle();
            javaParser.parse(rSyntaxDocument, string);
            return super.refreshPopupWindow();
        }
    }

    private class Listener
    implements CaretListener,
    ActionListener {
        private RSyntaxTextArea textArea;
        private Timer t;

        public Listener(RSyntaxTextArea rSyntaxTextArea) {
            this.textArea = rSyntaxTextArea;
            rSyntaxTextArea.addCaretListener(this);
            this.t = new Timer(650, this);
            this.t.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JavaParser javaParser = JavaLanguageSupport.this.getParser(this.textArea);
            if (javaParser == null) {
                return;
            }
            CompilationUnit compilationUnit = javaParser.getCompilationUnit();
            if (compilationUnit != null) {
                int n = this.textArea.getCaretPosition();
                Point point = compilationUnit.getEnclosingMethodRange(n);
                if (point != null) {
                    try {
                        int n2 = this.textArea.getLineOfOffset(point.x);
                        int n3 = Math.min(point.y, this.textArea.getDocument().getLength());
                        int n4 = this.textArea.getLineOfOffset(n3);
                        this.textArea.setActiveLineRange(n2, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    this.textArea.setActiveLineRange(-1, -1);
                }
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.t.restart();
        }

        public void uninstall() {
            this.textArea.removeCaretListener(this);
        }
    }
}

