/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.ShorthandCompletionCache;
import org.fife.rsta.ac.java.DocCommentCompletionProvider;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaShorthandCompletionCache;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.LanguageAwareCompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class JavaCompletionProvider
extends LanguageAwareCompletionProvider {
    private SourceCompletionProvider sourceProvider = (SourceCompletionProvider)this.getDefaultCompletionProvider();
    private CompilationUnit cu;

    public JavaCompletionProvider() {
        this((JarManager)null);
    }

    public JavaCompletionProvider(JarManager jarManager) {
        super(new SourceCompletionProvider(jarManager));
        this.sourceProvider.setJavaProvider(this);
        this.setShorthandCompletionCache(new JavaShorthandCompletionCache(this.sourceProvider, new DefaultCompletionProvider()));
        this.setDocCommentCompletionProvider(new DocCommentCompletionProvider());
    }

    public void addJar(LibraryInfo libraryInfo) throws IOException {
        this.sourceProvider.addJar(libraryInfo);
    }

    public void clearJars() {
        this.sourceProvider.clearJars();
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        return this.sourceProvider.getAlreadyEnteredText(jTextComponent);
    }

    public synchronized CompilationUnit getCompilationUnit() {
        return this.cu;
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent jTextComponent, Point point) {
        return this.sourceProvider.getCompletionsAt(jTextComponent, point);
    }

    public List<LibraryInfo> getJars() {
        return this.sourceProvider.getJars();
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent jTextComponent) {
        return null;
    }

    public boolean removeJar(File file) {
        return this.sourceProvider.removeJar(file);
    }

    private void setCommentCompletions(ShorthandCompletionCache shorthandCompletionCache) {
        AbstractCompletionProvider abstractCompletionProvider = shorthandCompletionCache.getCommentProvider();
        if (abstractCompletionProvider != null) {
            for (Completion completion : shorthandCompletionCache.getCommentCompletions()) {
                abstractCompletionProvider.addCompletion(completion);
            }
            this.setCommentCompletionProvider(abstractCompletionProvider);
        }
    }

    public synchronized void setCompilationUnit(CompilationUnit compilationUnit) {
        this.cu = compilationUnit;
    }

    public void setShorthandCompletionCache(ShorthandCompletionCache shorthandCompletionCache) {
        this.sourceProvider.setShorthandCache(shorthandCompletionCache);
        this.setCommentCompletions(shorthandCompletionCache);
    }
}

