/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.fife.rsta.ac.java.JavaSourceCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class JavaCellRenderer
extends DefaultListCellRenderer {
    private JList list;
    private boolean selected;
    private boolean evenRow;
    private JavaSourceCompletion jsc;
    private static Color altBG;
    private Completion nonJavaCompletion;
    private boolean simpleText;

    public static Color getAlternateBackground() {
        return altBG;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        this.setText("Foobar");
        this.list = jList;
        this.selected = bl;
        if (object instanceof JavaSourceCompletion) {
            this.jsc = (JavaSourceCompletion)object;
            this.nonJavaCompletion = null;
            this.setIcon(this.jsc.getIcon());
        } else {
            this.jsc = null;
            this.nonJavaCompletion = (Completion)object;
            this.setIcon(this.nonJavaCompletion.getIcon());
        }
        boolean bl3 = this.evenRow = (n & 1) == 0;
        if (altBG != null && this.evenRow && !bl) {
            this.setBackground(altBG);
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        Map<?, ?> map = RSyntaxUtilities.getDesktopAntiAliasHints();
        if (map != null) {
            object = graphics2D.getRenderingHints();
            graphics2D.addRenderingHints(map);
        } else {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n2 = this.getHeight();
        if (!this.selected) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), n2);
        } else {
            graphics.setColor(altBG != null && this.evenRow ? altBG : this.list.getBackground());
            graphics.fillRect(0, 0, 18, n2);
            graphics.setColor(this.getBackground());
            graphics.fillRect(18, 0, this.getWidth() - 18, n2);
        }
        if (this.getIcon() != null) {
            n = (n2 - this.getIcon().getIconHeight()) / 2;
            this.getIcon().paintIcon(this, graphics, 0, n);
        }
        n = this.getX() + 18 + 2;
        graphics.setColor(this.selected ? this.list.getSelectionForeground() : this.list.getForeground());
        if (this.jsc != null && !this.simpleText) {
            this.jsc.rendererText(graphics, n, graphics.getFontMetrics().getHeight(), this.selected);
        } else {
            Completion completion;
            Completion completion2 = completion = this.jsc != null ? this.jsc : this.nonJavaCompletion;
            if (completion != null) {
                graphics.drawString(completion.toString(), n, graphics.getFontMetrics().getHeight());
            }
        }
        if (map != null) {
            if (object instanceof Map) {
                graphics2D.addRenderingHints((Map)object);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static void setAlternateBackground(Color color) {
        altBG = color;
    }

    public void setSimpleText(boolean bl) {
        this.simpleText = bl;
    }
}

