/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.PackageNameCompletion;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

class JarReader {
    private LibraryInfo info;
    private TreeMap packageMap;
    private long lastModified;

    public JarReader(LibraryInfo libraryInfo) throws IOException {
        this.info = libraryInfo;
        this.packageMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.loadCompletions();
    }

    public void addCompletions(CompletionProvider completionProvider, String[] stringArray, Set<Completion> set) {
        Object object;
        this.checkLastModified();
        TreeMap treeMap = this.packageMap;
        int n = 0;
        while (n < stringArray.length - 1) {
            object = treeMap.get(stringArray[n]);
            if (!(object instanceof TreeMap)) {
                return;
            }
            treeMap = (TreeMap)object;
            ++n;
        }
        String string = stringArray[stringArray.length - 1];
        object = String.valueOf(string) + '{';
        SortedMap sortedMap = treeMap.subMap(string, object);
        for (String string2 : sortedMap.keySet()) {
            String[] stringArray2;
            Object v = sortedMap.get(string2);
            if (v instanceof ClassFile) {
                stringArray2 = (String[])v;
                boolean bl = false;
                if (!bl && !org.fife.rsta.ac.java.classreader.Util.isPublic(stringArray2.getAccessFlags())) continue;
                set.add(new ClassCompletion(completionProvider, (ClassFile)stringArray2));
                continue;
            }
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length - 1);
            stringArray2[stringArray2.length - 1] = string2.toString();
            ClassFile classFile = this.getClassEntry(stringArray2);
            if (classFile != null) {
                boolean bl = false;
                if (!bl && !org.fife.rsta.ac.java.classreader.Util.isPublic(classFile.getAccessFlags())) continue;
                set.add(new ClassCompletion(completionProvider, classFile));
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < stringArray.length - 1) {
                stringBuilder.append(stringArray[n2]).append('.');
                ++n2;
            }
            stringBuilder.append(string2.toString());
            String string3 = stringBuilder.toString();
            set.add(new PackageNameCompletion(completionProvider, string3, string));
        }
    }

    private void checkLastModified() {
        long l = this.info.getLastModified();
        if (l != 0L && l != this.lastModified) {
            int n = 0;
            n = this.clearClassFiles(this.packageMap);
            System.out.println("DEBUG: Cleared " + n + " cached ClassFiles");
            this.lastModified = l;
        }
    }

    private int clearClassFiles(Map map) {
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof ClassFile) {
                entry.setValue(null);
                ++n;
                continue;
            }
            if (!(v instanceof Map)) continue;
            n += this.clearClassFiles((Map)v);
        }
        return n;
    }

    public boolean containsClass(String string) {
        String[] stringArray = string.split("\\.");
        TreeMap treeMap = this.packageMap;
        int n = 0;
        while (n < stringArray.length - 1) {
            Object v = treeMap.get(stringArray[n]);
            if (!(v instanceof TreeMap)) {
                return false;
            }
            treeMap = (TreeMap)v;
            ++n;
        }
        return treeMap.containsKey(stringArray[stringArray.length - 1]);
    }

    public boolean containsPackage(String string) {
        String[] stringArray = Util.splitOnChar(string, 46);
        TreeMap treeMap = this.packageMap;
        int n = 0;
        while (n < stringArray.length) {
            Object v = treeMap.get(stringArray[n]);
            if (!(v instanceof TreeMap)) {
                return false;
            }
            treeMap = (TreeMap)v;
            ++n;
        }
        return true;
    }

    public ClassFile getClassEntry(String[] stringArray) {
        Object v;
        SortedMap<String, ClassFile> sortedMap = this.packageMap;
        int n = 0;
        while (n < stringArray.length - 1) {
            if (sortedMap.containsKey(stringArray[n])) {
                v = sortedMap.get(stringArray[n]);
                if (!(v instanceof SortedMap)) {
                    return null;
                }
            } else {
                return null;
            }
            sortedMap = (SortedMap)v;
            ++n;
        }
        String string = stringArray[stringArray.length - 1];
        if (sortedMap.containsKey(string)) {
            v = sortedMap.get(string);
            if (v instanceof Map) {
                return null;
            }
            if (v instanceof ClassFile) {
                ClassFile classFile = (ClassFile)v;
                return classFile;
            }
            try {
                StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
                int n2 = 1;
                while (n2 < stringArray.length) {
                    stringBuilder.append('/').append(stringArray[n2]);
                    ++n2;
                }
                stringBuilder.append(".class");
                ClassFile classFile = this.info.createClassFile(stringBuilder.toString());
                sortedMap.put(string, classFile);
                return classFile;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void getClassesInPackage(List<ClassFile> list, String[] stringArray, boolean bl) {
        SortedMap sortedMap = this.packageMap;
        int n = 0;
        while (n < stringArray.length) {
            Iterator iterator;
            if (sortedMap.containsKey(stringArray[n])) {
                iterator = sortedMap.get(stringArray[n]);
                if (!(iterator instanceof SortedMap)) {
                    return;
                }
            } else {
                return;
            }
            sortedMap = (SortedMap)((Object)iterator);
            ++n;
        }
        TreeMap treeMap = null;
        try {
            this.info.bulkClassFileCreationStart();
            try {
                for (Map.Entry entry : sortedMap.entrySet()) {
                    Object v = entry.getValue();
                    if (v == null) {
                        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
                        int n2 = 1;
                        while (n2 < stringArray.length) {
                            stringBuilder.append('/').append(stringArray[n2]);
                            ++n2;
                        }
                        stringBuilder.append('/');
                        stringBuilder.append((String)entry.getKey()).append(".class");
                        ClassFile classFile = this.info.createClassFileBulk(stringBuilder.toString());
                        if (treeMap == null) {
                            treeMap = new TreeMap();
                        }
                        treeMap.put(entry.getKey(), classFile);
                        this.possiblyAddTo(list, classFile, bl);
                        continue;
                    }
                    if (!(v instanceof ClassFile)) continue;
                    this.possiblyAddTo(list, (ClassFile)v, bl);
                }
            }
            finally {
                this.info.bulkClassFileCreationEnd();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (treeMap != null) {
            sortedMap.putAll(treeMap);
        }
    }

    public List<ClassFile> getClassesWithNamesStartingWith(String string) {
        ArrayList<ClassFile> arrayList = new ArrayList<ClassFile>();
        String string2 = "";
        this.getClassesWithNamesStartingWithImpl(string, this.packageMap, string2, arrayList);
        return arrayList;
    }

    private void getClassesWithNamesStartingWithImpl(String string, Map map, String string2, List<ClassFile> list) {
        int n = string.length();
        for (Map.Entry entry : map.entrySet()) {
            String string3 = (String)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Map) {
                this.getClassesWithNamesStartingWithImpl(string, (Map)object, String.valueOf(string2) + string3 + "/", list);
                continue;
            }
            String string4 = string3;
            if (!string4.regionMatches(true, 0, string, 0, n)) continue;
            if (object == null) {
                String string5 = String.valueOf(string2) + string4 + ".class";
                try {
                    object = this.info.createClassFile(string5);
                    entry.setValue(object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (object == null) continue;
            list.add((ClassFile)object);
        }
    }

    public LibraryInfo getLibraryInfo() {
        return (LibraryInfo)this.info.clone();
    }

    private void loadCompletions() throws IOException {
        this.packageMap = this.info.createPackageMap();
        this.lastModified = this.info.getLastModified();
    }

    private void possiblyAddTo(Collection<ClassFile> collection, ClassFile classFile, boolean bl) {
        if (bl || org.fife.rsta.ac.java.classreader.Util.isPublic(classFile.getAccessFlags())) {
            collection.add(classFile);
        }
    }

    public String toString() {
        return "[JarReader: " + this.getLibraryInfo() + "]";
    }
}

