/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.JarReader;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.JarLibraryInfo;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class JarManager {
    private List<JarReader> classFileSources = new ArrayList<JarReader>();
    private static boolean checkModified;

    public JarManager() {
        JarManager.setCheckModifiedDatestamps(true);
    }

    public void addCompletions(CompletionProvider completionProvider, String string, Set<Completion> set) {
        if (string.length() == 0) {
            return;
        }
        if (string.indexOf(46) > -1) {
            String[] stringArray = Util.splitOnChar(string, 46);
            int n = 0;
            while (n < this.classFileSources.size()) {
                JarReader jarReader = this.classFileSources.get(n);
                jarReader.addCompletions(completionProvider, stringArray, set);
                ++n;
            }
        } else {
            String string2 = string.toLowerCase();
            int n = 0;
            while (n < this.classFileSources.size()) {
                JarReader jarReader = this.classFileSources.get(n);
                List<ClassFile> list = jarReader.getClassesWithNamesStartingWith(string2);
                if (list != null) {
                    for (ClassFile classFile : list) {
                        if (!org.fife.rsta.ac.java.classreader.Util.isPublic(classFile.getAccessFlags())) continue;
                        set.add(new ClassCompletion(completionProvider, classFile));
                    }
                }
                ++n;
            }
        }
    }

    public boolean addClassFileSource(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("jarFile cannot be null");
        }
        return this.addClassFileSource(new JarLibraryInfo(file));
    }

    public boolean addClassFileSource(LibraryInfo libraryInfo) throws IOException {
        if (libraryInfo == null) {
            throw new IllegalArgumentException("info cannot be null");
        }
        int n = 0;
        while (n < this.classFileSources.size()) {
            JarReader jarReader = this.classFileSources.get(n);
            LibraryInfo libraryInfo2 = jarReader.getLibraryInfo();
            if (libraryInfo2.equals(libraryInfo)) {
                SourceLocation sourceLocation = libraryInfo.getSourceLocation();
                SourceLocation sourceLocation2 = libraryInfo2.getSourceLocation();
                if (sourceLocation == null && sourceLocation2 != null || sourceLocation != null && !sourceLocation.equals(sourceLocation2)) {
                    this.classFileSources.set(n, new JarReader((LibraryInfo)libraryInfo.clone()));
                    return true;
                }
                return false;
            }
            ++n;
        }
        this.classFileSources.add(new JarReader(libraryInfo));
        return true;
    }

    public void addCurrentJreClassFileSource() throws IOException {
        this.addClassFileSource(LibraryInfo.getMainJreJarInfo());
    }

    public void clearClassFileSources() {
        this.classFileSources.clear();
    }

    public static boolean getCheckModifiedDatestamps() {
        return checkModified;
    }

    public ClassFile getClassEntry(String string) {
        String[] stringArray = Util.splitOnChar(string, 46);
        int n = 0;
        while (n < this.classFileSources.size()) {
            JarReader jarReader = this.classFileSources.get(n);
            ClassFile classFile = jarReader.getClassEntry(stringArray);
            if (classFile != null) {
                return classFile;
            }
            ++n;
        }
        return null;
    }

    public List<ClassFile> getClassesWithUnqualifiedName(String string, List<ImportDeclaration> list) {
        ArrayList<Object> arrayList = null;
        for (ImportDeclaration object2 : list) {
            Object object;
            String string2;
            if (object2.isStatic()) continue;
            if (object2.isWildcard()) {
                string2 = object2.getName();
                string2 = string2.substring(0, string2.indexOf(42));
                object = this.getClassEntry(string2 = String.valueOf(string2) + string);
                if (object == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList(1);
                }
                arrayList.add(object);
                continue;
            }
            string2 = object2.getName();
            object = string2.substring(string2.lastIndexOf(46) + 1);
            if (!((String)object).equals(string)) continue;
            ClassFile classFile = this.getClassEntry(string2);
            if (classFile != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList(1);
                }
                arrayList.add(classFile);
                continue;
            }
            System.err.println("ERROR: Class not found! - " + string2);
        }
        String string3 = "java.lang." + string;
        ClassFile classFile = this.getClassEntry(string3);
        if (classFile != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(1);
            }
            arrayList.add(classFile);
        }
        return arrayList;
    }

    public List<ClassFile> getClassesInPackage(String string, boolean bl) {
        ArrayList<ClassFile> arrayList = new ArrayList<ClassFile>();
        String[] stringArray = Util.splitOnChar(string, 46);
        int n = 0;
        while (n < this.classFileSources.size()) {
            JarReader jarReader = this.classFileSources.get(n);
            jarReader.getClassesInPackage(arrayList, stringArray, bl);
            ++n;
        }
        return arrayList;
    }

    public List<LibraryInfo> getClassFileSources() {
        ArrayList<LibraryInfo> arrayList = new ArrayList<LibraryInfo>(this.classFileSources.size());
        for (JarReader jarReader : this.classFileSources) {
            arrayList.add(jarReader.getLibraryInfo());
        }
        return arrayList;
    }

    public SourceLocation getSourceLocForClass(String string) {
        SourceLocation sourceLocation = null;
        int n = 0;
        while (n < this.classFileSources.size()) {
            JarReader jarReader = this.classFileSources.get(n);
            if (jarReader.containsClass(string)) {
                sourceLocation = jarReader.getLibraryInfo().getSourceLocation();
                break;
            }
            ++n;
        }
        return sourceLocation;
    }

    public boolean removeClassFileSource(File file) {
        return this.removeClassFileSource(new JarLibraryInfo(file));
    }

    public boolean removeClassFileSource(LibraryInfo libraryInfo) {
        Iterator<JarReader> iterator = this.classFileSources.iterator();
        while (iterator.hasNext()) {
            JarReader jarReader = iterator.next();
            LibraryInfo libraryInfo2 = jarReader.getLibraryInfo();
            if (!libraryInfo2.equals(libraryInfo)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static void setCheckModifiedDatestamps(boolean bl) {
        checkModified = bl;
    }
}

