/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.util.Iterator;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;

class FieldInfoData
implements MemberCompletion.Data {
    private FieldInfo info;
    private SourceCompletionProvider provider;

    public FieldInfoData(FieldInfo fieldInfo, SourceCompletionProvider sourceCompletionProvider) {
        this.info = fieldInfo;
        this.provider = sourceCompletionProvider;
    }

    @Override
    public String getEnclosingClassName(boolean bl) {
        return this.info.getClassFile().getClassName(bl);
    }

    @Override
    public String getIcon() {
        String string = null;
        int n = this.info.getAccessFlags();
        string = org.fife.rsta.ac.java.classreader.Util.isDefault(n) ? "fieldDefaultIcon" : (org.fife.rsta.ac.java.classreader.Util.isPrivate(n) ? "fieldPrivateIcon" : (org.fife.rsta.ac.java.classreader.Util.isProtected(n) ? "fieldProtectedIcon" : (org.fife.rsta.ac.java.classreader.Util.isPublic(n) ? "fieldPublicIcon" : "fieldDefaultIcon")));
        return string;
    }

    @Override
    public String getSignature() {
        return this.info.getName();
    }

    @Override
    public String getSummary() {
        ClassFile classFile = this.info.getClassFile();
        SourceLocation sourceLocation = this.provider.getSourceLocForClass(classFile.getClassName(true));
        String string = null;
        if (sourceLocation != null) {
            string = this.getSummaryFromSourceLoc(sourceLocation, classFile);
        }
        if (string == null) {
            string = this.info.getName();
        }
        return string;
    }

    private String getSummaryFromSourceLoc(SourceLocation sourceLocation, ClassFile classFile) {
        String string = null;
        CompilationUnit compilationUnit = Util.getCompilationUnitFromDisk(sourceLocation, classFile);
        if (compilationUnit != null) {
            Iterator<TypeDeclaration> iterator = compilationUnit.getTypeDeclarationIterator();
            block0: while (iterator.hasNext()) {
                TypeDeclaration typeDeclaration = iterator.next();
                String string2 = typeDeclaration.getName();
                if (!string2.equals(classFile.getClassName(false))) continue;
                Iterator<Member> iterator2 = typeDeclaration.getMemberIterator();
                while (iterator2.hasNext()) {
                    Member member = iterator2.next();
                    if (!(member instanceof Field) || !member.getName().equals(this.info.getName())) continue;
                    Field field = (Field)member;
                    string = field.getDocComment();
                    continue block0;
                }
            }
        }
        return string;
    }

    @Override
    public String getType() {
        return this.info.getTypeString(false);
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.info.isDeprecated();
    }

    @Override
    public boolean isFinal() {
        return this.info.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.info.isStatic();
    }
}

