/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Graphics;
import javax.swing.Icon;
import org.fife.rsta.ac.java.AbstractJavaSourceCompletion;
import org.fife.rsta.ac.java.FieldData;
import org.fife.rsta.ac.java.FieldInfoData;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.MethodCompletion;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.FieldInfo;
import org.fife.rsta.ac.java.rjc.ast.Field;
import org.fife.rsta.ac.java.rjc.lang.Type;
import org.fife.ui.autocomplete.CompletionProvider;

class FieldCompletion
extends AbstractJavaSourceCompletion
implements MemberCompletion {
    private MemberCompletion.Data data;
    private static final int RELEVANCE = 3;

    public FieldCompletion(CompletionProvider completionProvider, Field field) {
        super(completionProvider, field.getName());
        this.data = new FieldData(field);
        this.setRelevance(3);
    }

    public FieldCompletion(CompletionProvider completionProvider, FieldInfo fieldInfo) {
        super(completionProvider, fieldInfo.getName());
        this.data = new FieldInfoData(fieldInfo, (SourceCompletionProvider)completionProvider);
        this.setRelevance(3);
    }

    private FieldCompletion(CompletionProvider completionProvider, String string) {
        super(completionProvider, string);
        this.setRelevance(3);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof FieldCompletion && ((FieldCompletion)object).getSignature().equals(this.getSignature());
    }

    public static FieldCompletion createLengthCompletion(CompletionProvider completionProvider, final Type type) {
        FieldCompletion fieldCompletion = new FieldCompletion(completionProvider, type.toString());
        fieldCompletion.data = new MemberCompletion.Data(){

            @Override
            public String getEnclosingClassName(boolean bl) {
                return type.getName(bl);
            }

            @Override
            public String getIcon() {
                return "fieldPublicIcon";
            }

            @Override
            public String getSignature() {
                return "length";
            }

            @Override
            public String getSummary() {
                return null;
            }

            @Override
            public String getType() {
                return "int";
            }

            @Override
            public boolean isConstructor() {
                return false;
            }

            @Override
            public boolean isDeprecated() {
                return false;
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public boolean isFinal() {
                return false;
            }

            @Override
            public boolean isStatic() {
                return false;
            }
        };
        return fieldCompletion;
    }

    @Override
    public String getEnclosingClassName(boolean bl) {
        return this.data.getEnclosingClassName(bl);
    }

    @Override
    public Icon getIcon() {
        return IconFactory.get().getIcon(this.data);
    }

    @Override
    public String getSignature() {
        return this.data.getSignature();
    }

    @Override
    public String getSummary() {
        String string = this.data.getSummary();
        if (string != null && string.startsWith("/**")) {
            string = Util.docCommentToHtml(string);
        }
        return string;
    }

    @Override
    public String getType() {
        return this.data.getType();
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    @Override
    public boolean isDeprecated() {
        return this.data.isDeprecated();
    }

    @Override
    public void rendererText(Graphics graphics, int n, int n2, boolean bl) {
        MethodCompletion.rendererText(this, graphics, n, n2, bl);
    }
}

