/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.fife.rsta.ac.java.IconFactory;

public class DecoratableIcon
implements Icon {
    private int width;
    private Icon mainIcon;
    private List<Icon> decorations;
    private boolean deprecated;
    private static final int DEFAULT_WIDTH = 24;

    public DecoratableIcon(Icon icon) {
        this(24, icon);
    }

    public DecoratableIcon(int n, Icon icon) {
        this.setMainIcon(icon);
        this.width = n;
    }

    public void addDecorationIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("decoration cannot be null");
        }
        if (this.decorations == null) {
            this.decorations = new ArrayList<Icon>(1);
        }
        this.decorations.add(icon);
    }

    @Override
    public int getIconHeight() {
        return this.mainIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.deprecated) {
            IconFactory.get().getIcon("deprecatedIcon").paintIcon(component, graphics, n, n2);
        }
        this.mainIcon.paintIcon(component, graphics, n, n2);
        if (this.decorations != null) {
            n = n + this.getIconWidth() - 8;
            int n3 = this.decorations.size() - 1;
            while (n3 >= 0) {
                Icon icon = this.decorations.get(n3);
                icon.paintIcon(component, graphics, n, n2);
                n -= 8;
                --n3;
            }
        }
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    public void setMainIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon cannot be null");
        }
        this.mainIcon = icon;
    }
}

