/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.Icon;
import org.fife.rsta.ac.java.AbstractJavaSourceCompletion;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

class ClassCompletion
extends AbstractJavaSourceCompletion {
    private ClassFile cf;

    public ClassCompletion(CompletionProvider completionProvider, ClassFile classFile) {
        super(completionProvider, classFile.getClassName(false));
        this.cf = classFile;
    }

    @Override
    public int compareTo(Completion completion) {
        if (completion == this) {
            return 0;
        }
        if (completion.toString().equalsIgnoreCase(this.toString()) && completion instanceof ClassCompletion) {
            ClassCompletion classCompletion = (ClassCompletion)completion;
            return this.getClassName(true).compareTo(classCompletion.getClassName(true));
        }
        return super.compareTo(completion);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ClassCompletion && ((ClassCompletion)object).getReplacementText().equals(this.getReplacementText());
    }

    public String getClassName(boolean bl) {
        return this.cf.getClassName(bl);
    }

    @Override
    public Icon getIcon() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.cf.getAccessFlags();
        if ((n & 0x200) > 0) {
            bl = true;
        } else if (org.fife.rsta.ac.java.classreader.Util.isPublic(n)) {
            bl2 = true;
        } else {
            bl3 = true;
        }
        IconFactory iconFactory = IconFactory.get();
        String string = null;
        if (bl) {
            string = bl3 ? "defaultInterfaceIcon" : "interfaceIcon";
        } else if (bl3) {
            string = "defaultClassIcon";
        } else if (bl2) {
            string = "classIcon";
        }
        return iconFactory.getIcon(string, this.cf.isDeprecated());
    }

    public String getPackageName() {
        return this.cf.getPackageName();
    }

    @Override
    public String getSummary() {
        CompilationUnit compilationUnit;
        SourceCompletionProvider sourceCompletionProvider = (SourceCompletionProvider)this.getProvider();
        SourceLocation sourceLocation = sourceCompletionProvider.getSourceLocForClass(this.cf.getClassName(true));
        if (sourceLocation != null && (compilationUnit = Util.getCompilationUnitFromDisk(sourceLocation, this.cf)) != null) {
            Iterator<TypeDeclaration> iterator = compilationUnit.getTypeDeclarationIterator();
            while (iterator.hasNext()) {
                String string;
                TypeDeclaration typeDeclaration = iterator.next();
                String string2 = typeDeclaration.getName();
                if (!string2.equals(this.cf.getClassName(false)) || (string = typeDeclaration.getDocComment()) == null || !string.startsWith("/**")) continue;
                return Util.docCommentToHtml(string);
            }
        }
        return this.cf.getClassName(true);
    }

    @Override
    public String getToolTipText() {
        return "class " + this.getReplacementText();
    }

    public int hashCode() {
        return this.getReplacementText().hashCode();
    }

    @Override
    public void rendererText(Graphics graphics, int n, int n2, boolean bl) {
        String string = this.cf.getClassName(false);
        graphics.drawString(string, n, n2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = n + fontMetrics.stringWidth(string);
        if (this.cf.isDeprecated()) {
            int n4 = n2 + fontMetrics.getDescent() - fontMetrics.getHeight() / 2;
            graphics.drawLine(n, n4, n3, n4);
        }
        n = n3;
        string = " - ";
        graphics.drawString(string, n, n2);
        n += fontMetrics.stringWidth(string);
        String string2 = this.cf.getClassName(true);
        int n5 = string2.lastIndexOf(46);
        if (n5 != -1) {
            string2 = string2.substring(0, n5);
            Color color = graphics.getColor();
            if (!bl) {
                graphics.setColor(Color.GRAY);
            }
            graphics.drawString(string2, n, n2);
            if (!bl) {
                graphics.setColor(color);
            }
        }
    }
}

