/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.fife.rsta.ac.AbstractMarkupLanguageSupport;
import org.fife.rsta.ac.html.HtmlCellRenderer;
import org.fife.rsta.ac.html.HtmlCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class HtmlLanguageSupport
extends AbstractMarkupLanguageSupport {
    private HtmlCompletionProvider provider;
    private static Set<String> tagsToClose = new HashSet<String>();

    static {
        tagsToClose = HtmlLanguageSupport.getTagsToClose("html5_close_tags.txt");
    }

    public HtmlLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(false);
        this.setShowDescWindow(true);
    }

    @Override
    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new HtmlCellRenderer();
    }

    private HtmlCompletionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new HtmlCompletionProvider();
        }
        return this.provider;
    }

    public static Set<String> getTagsToClose() {
        return tagsToClose;
    }

    private static final Set<String> getTagsToClose(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        InputStream inputStream = HtmlLanguageSupport.class.getResourceAsStream(string);
        if (inputStream != null) {
            String string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                    hashSet.add(string2.trim());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return hashSet;
    }

    @Override
    public void install(RSyntaxTextArea rSyntaxTextArea) {
        HtmlCompletionProvider htmlCompletionProvider = this.getProvider();
        AutoCompletion autoCompletion = this.createAutoCompletion(htmlCompletionProvider);
        autoCompletion.install(rSyntaxTextArea);
        this.installImpl(rSyntaxTextArea, autoCompletion);
        this.installKeyboardShortcuts(rSyntaxTextArea);
        rSyntaxTextArea.setToolTipSupplier(null);
    }

    @Override
    protected boolean shouldAutoCloseTag(String string) {
        return tagsToClose.contains(string.toLowerCase());
    }

    @Override
    public void uninstall(RSyntaxTextArea rSyntaxTextArea) {
        this.uninstallImpl(rSyntaxTextArea);
        this.uninstallKeyboardShortcuts(rSyntaxTextArea);
    }
}

