/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.html.AttributeCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

public class HtmlCompletionProvider
extends DefaultCompletionProvider {
    private Map<String, List<AttributeCompletion>> tagToAttrs;
    private boolean isTagName;
    private String lastTagName;

    public HtmlCompletionProvider() {
        this.initCompletions();
        this.tagToAttrs = new HashMap<String, List<AttributeCompletion>>();
        for (Completion completion : this.completions) {
            MarkupTagCompletion markupTagCompletion = (MarkupTagCompletion)completion;
            String string = markupTagCompletion.getName();
            ArrayList<AttributeCompletion> arrayList = new ArrayList<AttributeCompletion>();
            this.tagToAttrs.put(string.toLowerCase(), arrayList);
            int n = 0;
            while (n < markupTagCompletion.getAttributeCount()) {
                ParameterizedCompletion.Parameter parameter = markupTagCompletion.getAttribute(n);
                arrayList.add(new AttributeCompletion((CompletionProvider)this, parameter));
                ++n;
            }
        }
        this.setAutoActivationRules(false, "<");
    }

    protected String defaultGetAlreadyEnteredText(JTextComponent jTextComponent) {
        return super.getAlreadyEnteredText(jTextComponent);
    }

    private final boolean findLastTagNameBefore(RSyntaxDocument rSyntaxDocument, Token token, int n) {
        this.lastTagName = null;
        boolean bl = false;
        Object object = token;
        while (object != null) {
            if (object.containsPosition(n)) break;
            if (object.getType() == 26) {
                this.lastTagName = object.getLexeme();
            } else if (object.getType() == 25) {
                this.lastTagName = null;
                bl = object.isSingleChar('<');
                if ((object = object.getNextToken()) != null && !object.isWhitespace()) {
                    this.lastTagName = object.getLexeme();
                }
            }
            object = object.getNextToken();
        }
        if (this.lastTagName == null && !bl) {
            object = rSyntaxDocument.getDefaultRootElement();
            int n2 = object.getElementIndex(n) - 1;
            while (n2 >= 0) {
                Token token2 = token = rSyntaxDocument.getTokenListForLine(n2);
                while (token2 != null) {
                    if (token2.getType() == 26) {
                        this.lastTagName = token2.getLexeme();
                    } else if (token2.getType() == 25) {
                        this.lastTagName = null;
                        bl = token2.isSingleChar('<');
                        if ((token2 = token2.getNextToken()) != null && !token2.isWhitespace()) {
                            this.lastTagName = token2.getLexeme();
                        }
                    }
                    token2 = token2.getNextToken();
                }
                if (this.lastTagName != null || bl) break;
                --n2;
            }
        }
        return this.lastTagName != null;
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        String string;
        block16: {
            this.isTagName = true;
            this.lastTagName = null;
            string = super.getAlreadyEnteredText(jTextComponent);
            if (string != null) {
                int n = jTextComponent.getCaretPosition();
                if (n > 0) {
                    RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
                    try {
                        int n2 = rSyntaxTextArea.getLineOfOffset(n - 1);
                        Token token = rSyntaxTextArea.getTokenListForLine(n2);
                        if (token == null) break block16;
                        Token token2 = RSyntaxUtilities.getTokenAtOffset(token, n - 1);
                        if (token2 == null) {
                            string = null;
                        } else if (token2.getType() == 25) {
                            if (!HtmlCompletionProvider.isTagOpeningToken(token2)) {
                                string = null;
                            }
                        } else if (token2.getType() == 21) {
                            if (!HtmlCompletionProvider.insideMarkupTag(rSyntaxTextArea, token, n2, n)) {
                                string = null;
                            }
                        } else if (token2.getType() != 27 && token2.getType() != 26 && (token2.getType() > -1 || token2.getType() < -9)) {
                            string = null;
                        }
                        if (string != null) {
                            token2 = HtmlCompletionProvider.getTokenBeforeOffset(token, n - string.length());
                            boolean bl = this.isTagName = token2 != null && HtmlCompletionProvider.isTagOpeningToken(token2);
                            if (!this.isTagName) {
                                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                                this.findLastTagNameBefore(rSyntaxDocument, token, n);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    string = null;
                }
            }
        }
        return string;
    }

    protected List<AttributeCompletion> getAttributeCompletionsForTag(String string) {
        return this.tagToAttrs.get(this.lastTagName);
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent jTextComponent) {
        ArrayList<Completion> arrayList = new ArrayList<Completion>();
        String string = this.getAlreadyEnteredText(jTextComponent);
        List<Completion> list = this.getTagCompletions();
        if (this.lastTagName != null) {
            this.lastTagName = this.lastTagName.toLowerCase();
            list = this.getAttributeCompletionsForTag(this.lastTagName);
        }
        if (string != null && list != null) {
            int n = Collections.binarySearch(list, string, this.comparator);
            if (n < 0) {
                n = -n - 1;
            }
            while (n < list.size()) {
                Completion completion = list.get(n);
                if (!Util.startsWithIgnoreCase(completion.getInputText(), string)) break;
                arrayList.add(completion);
                ++n;
            }
        }
        return arrayList;
    }

    protected List<Completion> getTagCompletions() {
        return this.completions;
    }

    private static final Token getTokenBeforeOffset(Token token, int n) {
        if (token != null) {
            Token token2 = token;
            Token token3 = token.getNextToken();
            while (token3 != null) {
                if (token3.containsPosition(n)) {
                    return token2;
                }
                token2 = token3;
                token3 = token3.getNextToken();
            }
        }
        return null;
    }

    protected void initCompletions() {
        try {
            this.loadFromXML("data/html.xml");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final boolean insideMarkupTag(RSyntaxTextArea rSyntaxTextArea, Token token, int n, int n2) {
        int n3 = -1;
        Object object = token;
        while (object != null) {
            if (object.containsPosition(n2)) break;
            switch (object.getType()) {
                case 26: 
                case 27: {
                    n3 = 1;
                    break;
                }
                case 25: {
                    n3 = object.isSingleChar('>') ? 0 : 1;
                }
            }
            object = object.getNextToken();
        }
        if (n3 == -1) {
            int n4;
            n3 = n == 0 ? 0 : ((n4 = ((RSyntaxDocument)(object = (RSyntaxDocument)rSyntaxTextArea.getDocument())).getLastTokenTypeOnLine(n - 1)) <= -1 && n4 >= -9 ? 1 : 0);
        }
        return n3 == 1;
    }

    @Override
    public boolean isAutoActivateOkay(JTextComponent jTextComponent) {
        boolean bl = super.isAutoActivateOkay(jTextComponent);
        if (bl) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
            int n = rSyntaxTextArea.getCaretPosition();
            try {
                int n2 = rSyntaxTextArea.getLineOfOffset(n);
                Token token = rSyntaxTextArea.getTokenListForLine(n2);
                if (token != null) {
                    return !HtmlCompletionProvider.insideMarkupTag(rSyntaxTextArea, token, n2, n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return bl;
    }

    private static final boolean isTagOpeningToken(Token token) {
        return token.isSingleChar('<') || token.length() == 2 && token.charAt(0) == '<' && token.charAt(1) == '/';
    }
}

