/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.common;

import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenScanner {
    private RSyntaxDocument doc;
    private Element root;
    private Token t;
    private int line;

    public TokenScanner(RSyntaxTextArea rSyntaxTextArea) {
        this((RSyntaxDocument)rSyntaxTextArea.getDocument());
    }

    public TokenScanner(RSyntaxDocument rSyntaxDocument) {
        this.doc = rSyntaxDocument;
        this.root = rSyntaxDocument.getDefaultRootElement();
        this.line = 0;
        this.t = null;
    }

    public RSyntaxDocument getDocument() {
        return this.doc;
    }

    public Token next() {
        Token token = this.nextRaw();
        while (token != null && (token.isWhitespace() || token.isComment())) {
            token = this.nextRaw();
        }
        return token;
    }

    private Token nextRaw() {
        if (this.t == null || !this.t.isPaintable()) {
            int n = this.root.getElementCount();
            while (!(this.line >= n || this.t != null && this.t.isPaintable())) {
                this.t = this.doc.getTokenListForLine(this.line++);
            }
            if (this.line == n) {
                return null;
            }
        }
        Token token = this.t;
        this.t = this.t.getNextToken();
        return token;
    }
}

