/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.common;

import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.common.VariableDeclaration;

public class CodeBlock {
    private int start;
    private int end;
    private CodeBlock parent;
    private List<CodeBlock> children;
    private List<VariableDeclaration> varDecs;

    public CodeBlock(int n) {
        this.start = n;
        this.end = Integer.MAX_VALUE;
    }

    public CodeBlock addChildCodeBlock(int n) {
        CodeBlock codeBlock = new CodeBlock(n);
        codeBlock.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<CodeBlock>();
        }
        this.children.add(codeBlock);
        return codeBlock;
    }

    public void addVariable(VariableDeclaration variableDeclaration) {
        if (this.varDecs == null) {
            this.varDecs = new ArrayList<VariableDeclaration>();
        }
        this.varDecs.add(variableDeclaration);
    }

    public boolean contains(int n) {
        return n >= this.start && n < this.end;
    }

    public CodeBlock getChildCodeBlock(int n) {
        return this.children.get(n);
    }

    public int getChildCodeBlockCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public CodeBlock getDeepestCodeBlockContaining(int n) {
        if (!this.contains(n)) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.getChildCodeBlockCount()) {
            CodeBlock codeBlock = this.getChildCodeBlock(n2);
            if (codeBlock.contains(n)) {
                return codeBlock.getDeepestCodeBlockContaining(n);
            }
            ++n2;
        }
        return this;
    }

    public int getEndOffset() {
        return this.end;
    }

    public CodeBlock getParent() {
        return this.parent;
    }

    public int getStartOffset() {
        return this.start;
    }

    public VariableDeclaration getVariableDeclaration(int n) {
        return this.varDecs.get(n);
    }

    public int getVariableDeclarationCount() {
        return this.varDecs == null ? 0 : this.varDecs.size();
    }

    public List<VariableDeclaration> getVariableDeclarationsBefore(int n) {
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        int n2 = this.getVariableDeclarationCount();
        int n3 = 0;
        while (n3 < n2) {
            VariableDeclaration variableDeclaration = this.getVariableDeclaration(n3);
            if (variableDeclaration.getOffset() >= n) break;
            arrayList.add(variableDeclaration);
            ++n3;
        }
        if (this.parent != null) {
            arrayList.addAll(this.parent.getVariableDeclarationsBefore(n));
        }
        return arrayList;
    }

    public void setEndOffset(int n) {
        this.end = n;
    }
}

